﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        InitializeTarget Module

    .DESCRIPTION
        This file defines functions for target initialization operations
#>

$moduleFilePath = $MyInvocation.MyCommand.Path
$modulePath     = [System.IO.Path]::GetDirectoryName($moduleFilePath)
$moduleRootPath = [System.IO.Path]::GetDirectoryName($modulePath)

Import-Module "${moduleRootPath}\Path"
Import-Module "${moduleRootPath}\HostBridge"

<#
    .SYNOPSIS
        Get the target key (PKC) type
#>
function Get-TargetFusedKeyType
{
    param
    (
        [Parameter(Mandatory=$true)]
        [string]
        # The host IP address
        $HostBridgeAddress
    )

    $Version = Get-HostBridgeHardwareVersion $HostBridgeAddress

    if($LastExitCode -ne 0)
    {
        throw "Get HostBridge hardware version failed. ExitCode = $LastExitCode"
    }

    switch ( $Version )
    {
        "1" # SDEV1.5
        {
            $Type = 'K1'
        }

        "2" # SDEV1.6
        {
            $Type = 'K1'
        }

        "3" # SDEV1.8
        {
            $Type = 'K2'
        }

        "4" # SDEV1.6+G
        {
            $Type = 'K1'
        }

        "5" # SDEV preMP1
        {
            $Type = 'K3'
        }

        "6" # SDEV preMP2
        {
            $Type = 'K3'
        }

        "7" # SDEV MP
        {
            $Type = 'K5'
        }

        "8" # Odin-Mariko
        {
            $Type = 'M1'
        }

        "9" # Odin-Mariko
        {
            $Type = 'M2'
        }

        default
        {
            throw "HostBridge hardware version `"$Version`" is not supported."
        }
    }

    return $Type
}
Export-ModuleMember -Function Get-TargetFusedKeyType
