﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        BuildSettings Module

    .DESCRIPTION
        This file defines accessors to SIGLO build settings.
#>

$moduleFilePath = $MyInvocation.MyCommand.Path
$modulePath     = [System.IO.Path]::GetDirectoryName($moduleFilePath)

$ToolChainSettings = [xml](Get-Content (Join-Path $modulePath ..\..\..\..\Common\Build\Settings\ToolChains.xml))

<#
    .SYNOPSIS
        Returns the version of the specified toolchain used by the current tree.

    .OUTPUTS
        Version string
#>
function Get-BuildToolChainVersion([string] $toolChainId)
{
    $element = $ToolChainSettings.SelectSingleNode("/ToolChains/ToolChain[@id='$toolChainId']/Version")

    if ($element -eq $null)
    {
        throw "ToolChain '$toolChainId' not found."
    }

    return $element.InnerText
}
Export-ModuleMember -Function Get-BuildToolChainVersion

<#
    .SYNOPSIS
        Returns the version of Nact used by the current siglo build system.

    .OUTPUTS
        Version string
#>
function Get-NactVersion
{
    return (Get-Content (Join-Path $modulePath ..\..\..\..\Integrate\CommandLineTools\NactVersion.txt)).TrimEnd()
}
Export-ModuleMember -Function Get-NactVersion
