﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)

Import-Module "${ScriptDirectoryPath}\Modules\Error"
Import-Module "${ScriptDirectoryPath}\Modules\Path"

$params = $Args

if( $params.count -eq 0 ) {
    # set default targets
    $root   = $(Get-NintendoSdkRootPath)
    $params = "${root}\Programs", "${root}\Samples", "${root}\Tests"
}

# work around for data corruption
$pinfo = New-Object System.Diagnostics.ProcessStartInfo
$pinfo.FileName                 = "$(Get-NintendoSdkIntegrateRootPath)\CommandLineTools\checkCppCode.cmd"
$pinfo.RedirectStandardError    = $true
$pinfo.RedirectStandardOutput   = $true
$pinfo.UseShellExecute          = $false
$pinfo.Arguments                = $params

$process = New-Object System.Diagnostics.Process
$process.StartInfo = $pinfo
$process.Start() | Out-Null

$stderr = $process.StandardError.ReadToEnd()
$process.WaitForExit()

$str_array = $stderr -split "\n"

$i=0
foreach ($l in $str_array) {
    if( $l -match "^\S:" )
    {
        Write-Host $l
        $i++
    }
    if( $i -ge 1000 )
    {
        break
    }
}

# return total error count
exit $process.ExitCode
