<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>
Param
(
    $ArgServerUrl, 
    $ArgMaxRevisionStr, 
    $ArgMinRevisionStr, 
    $ArgOrientedBuildId, 
    $ArgAgentName, 
    $ArgAuthenticationFile, 
    $ArgBuildConfName, 
    $ArgBuildId, 
    $ArgGitPath, 
    $ArgCurrentBranch
)

#ʊ֐̃[h
$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)
Import-Module "${scriptDirectoryPath}\Modules\ErrorCommitRevisionFunctions"

<#
    .SYNOPSIS
        rhWu擾
#>
function Get-BuildConfName
{
    $buildId = Get-BuildId

    $ServerUrl = Get-ServerUrl $ArgServerUrl
    $QueryUrl = "$ServerUrl/app/rest/builds/id:$buildId"
    $XmlStr = Invoke-DownloadString $WebClient $QueryUrl
    try
    {
        $Xml = [xml]$XmlStr
        $BuildConfName = $Xml.build.buildType.GetAttribute("name")
    }
    catch
    {
        $exceptionDetails = $_.Exception
        Write-Host "BuildConfName̎擾Ɏs܂: $XmlStr $exceptionDetails"
        exit 1
    }

    if($BuildConfName -eq "" -or $BuildConfName -eq $null)
    {
        Write-Host "BuildConfName̎擾Ɏs܂"
        exit 1
    }
    return $BuildConfName
}

<#
    .SYNOPSIS
        rhID擾
#>
function Get-BuildId
{
    $BuildId = $ArgBuildId
    if($BuildId -eq "" -or $BuildId -eq $null)
    {
        Write-Host "BuildId̎擾Ɏs܂"
        exit 1
    }
    return $BuildId
}

<#
    .SYNOPSIS
        WuTypeID擾
#>
function Get-BuildTypeId
{
    $buildId = Get-BuildId

    $ServerUrl = Get-ServerUrl $ArgServerUrl
    $QueryUrl = "$ServerUrl/app/rest/builds/id:$buildId"
    $XmlStr = Invoke-DownloadString $WebClient $QueryUrl
    try
    {
        $Xml = [xml]$XmlStr
        $BuildTypeId = $Xml.build.GetAttribute("buildTypeId")
    }
    catch
    {
        $exceptionDetails = $_.Exception
        Write-Host "BuildTypeId̎擾Ɏs܂: $XmlStr $exceptionDetails"
        exit 1
    }

    if($BuildTypeId -eq "" -or $BuildTypeId -eq $null)
    {
        Write-Host "BuildTypeId̎擾Ɏs܂"
        exit 1
    }
    return $BuildTypeId
}

<#
    .SYNOPSIS
        rh̃rW擾
#>
function Get-CurrentRevision
{
    $buildId = Get-BuildId

    $ServerUrl = Get-ServerUrl $ArgServerUrl
    $QueryUrl = "$ServerUrl/app/rest/builds/id:$buildId"
    $XmlStr = Invoke-DownloadString $WebClient $QueryUrl
    try
    {
        $Xml = [xml]$XmlStr
        foreach($revision in $Xml.build.revisions.revision){
            $BuidlIdRevision = $revision.GetAttribute("version")
            break
        }
    }
    catch
    {
        $exceptionDetails = $_.Exception
        Write-Host "CurrentRevision̎擾Ɏs܂: $XmlStr $exceptionDetails"
        exit 1
    }
    if($BuidlIdRevision -eq "" -or $BuidlIdRevision -eq $null)
    {
        Write-Host "BuidlIdRevision̎擾Ɏs܂"
        exit 1
    }
    return $BuidlIdRevision
}

<#
    .SYNOPSIS
        rh̃u`擾
#>
function Get-CurrentBranch
{
    $CurrentBranch = $ArgCurrentBranch
    if($CurrentBranch -eq "" -or $CurrentBranch -eq $null)
    {
        Write-Host "CurrentBranch̎擾Ɏs܂"
        exit 1
    }
    return $CurrentBranch
}

<#
    .SYNOPSIS
        2TJñrW擾
#>
function Get-OrientedBuildIdRevision
{
    $buildId = Get-OrientedBuildId $ArgOrientedBuildId

    $ServerUrl = Get-ServerUrl $ArgServerUrl
    $QueryUrl = "$ServerUrl/app/rest/builds/id:$buildId"
    $XmlStr = Invoke-DownloadString $WebClient $QueryUrl
    
    try
    {
        $Xml = [xml]$XmlStr
        foreach($revision in $Xml.build.revisions.revision){
            $BuidlIdRevision = $revision.GetAttribute("version")
            break
        }
    }
    catch
    {
        $exceptionDetails = $_.Exception
        Write-Host "OrientedBuildIdRevision̎擾Ɏs܂: $XmlStr $exceptionDetails"
        exit 1
    }

    if($BuidlIdRevision -eq "" -or $BuidlIdRevision -eq $null)
    {
        Write-Host "OrientedBuildIdRevision̎擾Ɏs܂"
        exit 1
    }
    return $BuidlIdRevision
}

<#
    .SYNOPSIS
        ߂̐Revision擾

    .PARAMETER WebClient
        httpʐMNX
#>
function Get-NewestSuccessRevision
{
    Param
    (
        $WebClient
    )
    $CurrentBranch = Get-CurrentBranch
    $BuildConfName = Get-BuildConfName

    $ServerUrl = Get-ServerUrl $ArgServerUrl
    $MinSuccessQueryUrl = "$ServerUrl/httpAuth/app/rest/builds/?locator=buildType:$BuildConfName,status:success,count:1,branch:$CurrentBranch&fields=build(id)"
    Write-Host $MinSuccessQueryUrl
    $MinSuccessXmlStr = Invoke-DownloadString $WebClient $MinSuccessQueryUrl
    try
    {
        $XmlMinSuccess = [xml]$MinSuccessXmlStr
        if($XmlMinSuccess.builds.build -eq $null)
        {
            return $null
        }
        $MinSuccessId = $XmlMinSuccess.builds.build.GetAttribute("id")
    }
    catch
    {
        $exceptionDetails = $_.Exception
        Write-Host "߂̐rhID擾Ɏs܂: $MinSuccessXmlStr $exceptionDetails"
        exit 1
    }
    if($MinSuccessId -eq "" -or $MinSuccessId -eq $null)
    {
        Write-Host "߂̐rhID擾Ɏs܂"
        exit 1
    }

    $ServerUrl = Get-ServerUrl $ArgServerUrl
    $MinRevisionUrl = "$ServerUrl/httpAuth/app/rest/builds/id:$MinSuccessId/resulting-properties/build.vcs.number"
    Write-Host $MinRevisionUrl
    #߂̐Revision擾
    $MinRevisionStr = Invoke-DownloadString $WebClient $MinRevisionUrl
    if($MinRevisionStr -eq "" -or $MinRevisionStr -eq $null)
    {
        Write-Host "߂̐rhrW擾Ɏs܂"
        exit 1
    }
    return $MinRevisionStr
}

<#
    .SYNOPSIS
        ŌÂ̎sRevision擾

    .PARAMETER WebClient
        httpʐMNX
#>
function Get-OldestFailedRevision
{
    Param
    (
        $WebClient
    )
    $CurrentBranch = Get-CurrentBranch
    $BuildConfName = Get-BuildConfName
    $LastFailId = ""
    $MaxRevisionStr = ""

    $ServerUrl = Get-ServerUrl $ArgServerUrl
    $BuildHistoryUrl = "$ServerUrl/httpAuth/app/rest/builds/?locator=buildType:$BuildConfName,branch:$CurrentBranch&fields=build(id,status)"
    Write-Host $BuildHistoryUrl
    $BuildHistoryXmlStr = Invoke-DownloadString $WebClient $BuildHistoryUrl
    try
    {
        $XmlBuildHistory = [xml]$BuildHistoryXmlStr
        if($XmlBuildHistory.builds.build -eq $null)
        {
            Write-Host "ŐVRevision擾(Ȃ)"
            $MaxRevisionStr = Get-CurrentRevision
            return $MaxRevisionStr
        }

        foreach($build in $XmlBuildHistory.builds.build)
        {
            if($build.GetAttribute("status") -eq "")
            {
                Write-Host "ŌÂ̎srhrW擾Ɏs܂"
                exit 1
            }
            if($build.GetAttribute("status") -eq "SUCCESS")
            {
                break
            }
            $LastFailId = $build.GetAttribute("id")
        }
    }
    catch
    {
        $exceptionDetails = $_.Exception
        Write-Host "ŌÂ̎srhrW擾Ɏs܂ $BuildHistoryXmlStr $exceptionDetails"
        exit 1
    }

    if($LastFailId -eq "")
    {
        Write-Host "ŐVRevision擾"
        $MaxRevisionStr = Get-CurrentRevision
    }
    else
    {
        $ServerUrl = Get-ServerUrl $ArgServerUrl
        $MaxRevisionQueryUrl = "$ServerUrl/httpAuth/app/rest/builds/id:$LastFailId/resulting-properties/build.vcs.number"
        Write-Host $MaxRevisionQueryUrl
        #ŌÂ̎sRevision擾
        $MaxRevisionStr = Invoke-DownloadString $WebClient $MaxRevisionQueryUrl
    }
    if($MaxRevisionStr -eq "" -or $MaxRevisionStr -eq $null)
    {
        Write-Host "ŌÂ̎srhrW擾Ɏs܂"
        exit 1
    }
    return $MaxRevisionStr
}

<#
    .SYNOPSIS
        git bisectŒԂRevision擾

    .PARAMETER MaxRevisionStr
        2T̊JnrW

    .PARAMETER MinRevisionStr
        2T̏IrW
#>
function Get-MiddleRevision
{
    Param
    (
        $MaxRevisionStr,
        $MinRevisionStr
    )
    $GitPath = $ArgGitPath
    $CheckoutResult = & "$GitPath" checkout $MaxRevisionStr
    $GitRevisions = & "$GitPath" log -2 --format=%H
    
    foreach($GitRevision in $GitRevisions)
    {
        $GitRevision = [String]$GitRevision
    }

    if( ($MaxRevisionStr -eq [String]$GitRevisions[0]) -and ($MinRevisionStr -eq [String]$GitRevisions[1]) )
    {
        Write-Host "G[芮"
        Write-Host $MaxRevisionStr
        return $MaxRevisionStr
    }

    $GitResulrObjs = & "$GitPath" bisect start $MaxRevisionStr $MinRevisionStr
    if($LastExitCode) {
        Write-Host "git bisect s"
        return $null
    }

    $MiddleRevision = & "$GitPath" show -s --format=%H
    if($MiddleRevision -eq "" -or $MiddleRevision -eq $null)
    {
        Write-Host "ԃrW擾Ɏs܂"
        exit 1
    }

    return $MiddleRevision
}

<#
    .SYNOPSIS
        2̍ŌƂMAX̃rWƂĊmA^Oł

    .PARAMETER WebClient
        httpʐMNX

    .PARAMETER FixedRevision
        G[łrW

    .PARAMETER OrientedBuildId
        2Tʂ^Ot^ƂȂrhID
#>
function Stamp-BuildTag
{
    Param
    (
        $WebClient,
        $FixedRevision,
        $OrientedBuildId
    )
    Write-Host "G[o[Wł܂B: $FixedRevision"
    $Xml = New-Object System.Xml.XmlDocument
    $Tags = $Xml.CreateElement("tags")
    $Tag = $Xml.CreateElement("tag")
    $Tags.SetAttribute("count", "1")
    $Tag.SetAttribute("name", $FixedRevision)
    $Tags.AppendChild($Tag)
    $Xml.AppendChild($Tags)
    $ServerUrl = Get-ServerUrl $ArgServerUrl
    $StampTagUrl = "$ServerUrl/httpAuth/app/rest/builds/id:$OrientedBuildId/tags/"
    Write-Host $StampTagUrl

    Invoke-Posthttp $StampTagUrl $Xml.OuterXml $ArgAuthenticationFile
}

<#
    .SYNOPSIS
        ChangeIdvcs-root-instanceɊ܂܂̂ǂ𔻒f

    .PARAMETER WebClient
        httpʐMNX

    .PARAMETER ChangeId
        change Id
#>
function Check-VcsRootId
{
    Param
    (
        $WebClient,
        $ChangeId
    )
    $BuildId = Get-BuildId
    $ServerUrl = Get-ServerUrl $ArgServerUrl
    $BuildResultUrl = "$ServerUrl/httpAuth/app/rest/builds/id:$BuildId"
    Write-Host "BUILD_RESULT_URL: $BuildResultUrl"

    # Wusʂ̎擾
    $XmlStr = Invoke-DownloadString $WebClient $BuildResultUrl
    Write-Host $XmlStr

    $ServerUrl = Get-ServerUrl $ArgServerUrl
    $ChangeIdUrl = "$ServerUrl/httpAuth/app/rest/changes/id:$ChangeId"
    Write-Host $ChangeIdUrl
    $ChangeIdXmlStr = Invoke-DownloadString $WebClient $ChangeIdUrl

    try
    {
        $XmlData = [xml]$XmlStr
        $XmlChangeIdResult = [xml]$ChangeIdXmlStr

        foreach($revision in $XmlData.build.revisions.revision)
        {
            $SigloSdkStr = $revision.{vcs-root-instance}.GetAttribute("vcs-root-id")
            if($SigloSdkStr -eq "")
            {
                Write-Host "VcsRootId̔fɎs܂"
                exit 1
            }
            if($XmlChangeIdResult.change.vcsRootInstance.GetAttribute("vcs-root-id") -eq $SigloSdkStr)
            {
                return $true
            }
        }
        return $false
    }
    catch
    {
        $exceptionDetails = $_.Exception
        Write-Host "VcsRootId̔fɎs܂: $ChangeIdXmlStr $exceptionDetails"
        exit 1
    }
}

<#
    .SYNOPSIS
        RevisionŃp[\irh{

    .PARAMETER WebClient
        httpʐMNX

    .PARAMETER MiddleRevision
        2Tɂ莟Ƀrh郊rW

    .PARAMETER OrientedBuildId
        2Tʂ^Ot^ƂȂrhID

    .PARAMETER MaxRevisionStr
        2T̊JnrW

    .PARAMETER MinRevisionStr
        2T̏IrW
#>
function Queue-PersonalBuild
{
    Param
    (
        $WebClient,
        $MiddleRevision,
        $OrientedBuildId,
        $OrientedBuildIdRevision,
        $MaxRevisionStr,
        $MinRevisionStr
    )
    $CurrentBranch = Get-CurrentBranch
    $BuildTypeId = Get-BuildTypeId

    $AgentName = Get-AgentName $ArgAgentName
    $ServerUrl = Get-ServerUrl $ArgServerUrl
    $AgentIdUrl = "$ServerUrl/app/rest/agents?locator=name:$AgentName"
    Write-Host $AgentIdUrl
    $AgentXmlStr = Invoke-DownloadString $WebClient $AgentIdUrl
    try
    {
        $XmlAgentResult = [xml]$AgentXmlStr
        $AgentIdStr = $XmlAgentResult.agents.agent.GetAttribute("id")
        if($AgentIdStr -eq "" -or $AgentIdStr -eq $null)
        {
            Write-Host "p[\irh̎{Ɏs܂"
            exit 1
        }
    }
    catch
    {
        $exceptionDetails = $_.Exception
        Write-Host "p[\irh̎{Ɏs܂: $AgentXmlStr $exceptionDetails"
        exit 1
    }

    $ServerUrl = Get-ServerUrl $ArgServerUrl
    $ChangeIdUrl = "$ServerUrl/app/rest/changes?locator=version:$MiddleRevision"
    Write-Host $ChangeIdUrl
    $ChangeIdXmlStr = Invoke-DownloadString $WebClient $ChangeIdUrl
    try
    {
        $matchedCount = 0
        $CheckResult = $false
        $ChangeIdStr = ""
        $XmlChangeIdResult = [xml]$ChangeIdXmlStr
        foreach($change in $XmlChangeIdResult.changes.change)
        {
            $ChangeIdStrOnce = $change.GetAttribute("id")
            if($ChangeIdStrOnce -eq "" -or $ChangeIdStrOnce -eq $null)
            {
                Write-Host "p[\irh̎{Ɏs܂"
                exit 1
            }
            $CheckResultOnce = Check-VcsRootId $WebClient $ChangeIdStrOnce
            if($CheckResultOnce -eq $true)
            {
                if($matchedCount -eq 1)
                {
                    Write-Host "p[\irh̎{Ɏs܂: vcs-root-idv"
                    exit 1
                }
                $matchedCount = 1
                $CheckResult = $true
                $ChangeIdStr = $ChangeIdStrOnce
            }
        }
        Write-Host $ChangeIdStr
        if($CheckResult -eq $false)
        {
            Write-Host "p[\irh̎{Ɏs܂: vcs-root-idȂ"
            exit 1
        }
    }
    catch
    {
        $exceptionDetails = $_.Exception
        Write-Host "p[\irh̎{Ɏs܂: $ChangeIdXmlStr $exceptionDetails"
        exit 1
    }

    #ԃo[WŃp[\irh̎{
    $Xml = New-Object System.Xml.XmlDocument
    $build = $Xml.CreateElement("build")
    $build.SetAttribute("personal", "true")
    $build.SetAttribute("branchName", $CurrentBranch)
    $buildType = $Xml.CreateElement("buildType")
    $buildType.SetAttribute("id", $BuildTypeId)
    $build.AppendChild($buildType)
    $agent = $Xml.CreateElement("agent")
    $agent.SetAttribute("id", $AgentIdStr)
    $build.AppendChild($agent)
    $properties = $Xml.CreateElement("properties")
    $propertyMaxRevision = $Xml.CreateElement("property")
    $propertyMaxRevision.SetAttribute("name", "env.SPECIFY_MAX_REVISION")
    $propertyMaxRevision.SetAttribute("value", $MaxRevisionStr)
    $properties.AppendChild($propertyMaxRevision)
    $propertyMinRevision = $Xml.CreateElement("property")
    $propertyMinRevision.SetAttribute("name", "env.SPECIFY_MIN_REVISION")
    $propertyMinRevision.SetAttribute("value", $MinRevisionStr)
    $properties.AppendChild($propertyMinRevision)
    $propertyOrientedBuildId = $Xml.CreateElement("property")
    $propertyOrientedBuildId.SetAttribute("name", "env.SPECIFY_ORIENTED_BUILDID")
    $propertyOrientedBuildId.SetAttribute("value", $OrientedBuildId)
    $properties.AppendChild($propertyOrientedBuildId)
    $propertyOrientedBuildIdRevision = $Xml.CreateElement("property")
    $propertyOrientedBuildIdRevision.SetAttribute("name", "env.SPECIFY_ORIENTED_BUILDIDREVISION")
    $propertyOrientedBuildIdRevision.SetAttribute("value", $OrientedBuildIdRevision)
    $properties.AppendChild($propertyOrientedBuildIdRevision)
    $build.AppendChild($properties)
    $lastChanges = $Xml.CreateElement("lastChanges")
    $change = $Xml.CreateElement("change")
    $change.SetAttribute("id", $ChangeIdStr)
    $lastChanges.AppendChild($change)
    $build.AppendChild($lastChanges)
    $Xml.AppendChild($build)
    Write-Host $Xml.OuterXml

    $ServerUrl = Get-ServerUrl $ArgServerUrl
    $QueueUrl = "$ServerUrl/httpAuth/app/rest/buildQueue/"
    Write-Host $QueueUrl

    Invoke-Posthttp $QueueUrl $Xml.OuterXml $ArgAuthenticationFile
}

# ܂ŃTu֐
# ||||||||||||||||

# C̃vOt[
Write-Host $ArgServerUrl
Write-Host $ArgMaxRevisionStr
Write-Host $ArgMinRevisionStr
Write-Host $ArgOrientedBuildId
Write-Host $ArgAgentName
Write-Host $ArgAuthenticationFile
Write-Host $ArgBuildId
Write-Host $ArgGitPath
Write-Host $ArgCurrentBranch

# REST APIID/PASS̎擾āAhttpʐMpWebClient̍쐬
$NetworkCredential = Get-NetworkCredential $ArgAuthenticationFile
$WebClient = New-Object System.Net.WebClient
$WebClient.Credentials = $NetworkCredential
$WebClient.Encoding = [System.Text.Encoding]::UTF8

# Wusʂ̎擾
$BuildConfName = Get-BuildConfName
$BuildId = Get-BuildId
$CurrentBranch = Get-CurrentBranch
$CurrentJobResult = Get-CurrentJobResult $WebClient $BuildConfName $ArgServerUrl $BuildId $CurrentBranch

$OrientedBuildId = Get-OrientedBuildId $ArgOrientedBuildId
$OrientedBuildIdRevision = ""
$MinRevisionStr = ""
$MaxRevisionStr = ""
# 񂩁H
if($OrientedBuildId -eq "")
{
    # YES

    $OrientedBuildId = Get-BuildId
    $ArgOrientedBuildId = $OrientedBuildId
    $OrientedBuildIdRevision = Get-OrientedBuildIdRevision

    #Wus
    if($CurrentJobResult -eq "SUCCESS")
    {
        # 
        exit 0
    }
    # s

    # ߂̐Revision擾
    $MinRevisionStr = Get-NewestSuccessRevision $WebClient

    # ŌÂ̎sRevision擾
    $MaxRevisionStr = Get-OldestFailedRevision $WebClient

    if($MinRevisionStr -eq $null)
    {
@@@@Stamp-BuildTag $WebClient $MaxRevisionStr $OrientedBuildId
        exit 0
    }

}
else
{
    # NO

    $MinRevisionStr = Get-EnvMinRevision $ArgMinRevisionStr
    $MaxRevisionStr = Get-EnvMaxRevision $ArgMaxRevisionStr

    $CurrentRevision = Get-CurrentRevision
    $OrientedBuildIdRevision = Get-OrientedBuildIdRevision
    if($OrientedBuildIdRevision -eq $CurrentRevision)
    {
        #ҒʂcheckoutłA2T[v邽ߒf
        Write-Host "checkoutł܂łB2T𒆒f܂B(ŏ̃rWƎ{rhrW)"
        exit 0
    }
    if($MaxRevisionStr -eq $CurrentRevision)
    {
        #ҒʂcheckoutłA2T[v邽ߒf
        Write-Host "checkoutł܂łB2T𒆒f܂B(MAXƎ{rhrW)"
        exit 0
    }
    if($MinRevisionStr -eq $CurrentRevision)
    {
        #ҒʂcheckoutłA2T[v邽ߒf
        Write-Host "checkoutł܂łB2T𒆒f܂B(MINƎ{rhrW)"
        exit 0
    }

    # Wus
    if($CurrentJobResult -eq "SUCCESS")
    {
        # 
        # ݂Revision擾@MINɐݒ
        $MinRevisionStr = $CurrentRevision
    }
    else
    {
        # s
        # ݂Revision擾@MAXɐݒ
        $MaxRevisionStr = $CurrentRevision
    }
}

#git bisectŒԃo[W̎擾
$MiddleRevision = Get-MiddleRevision $MaxRevisionStr $MinRevisionStr
#MINAMAX̂ꂩƓrWH
if($MiddleRevision -eq $null)
{
    #YES
    #git bisect̎sG[ĩG[ŉӏ荢j
    Write-Host "̃G[vɂG[肪ł܂łB(git bisect̎sG[)"
}
elseif($MiddleRevision -eq $MaxRevisionStr -or $MiddleRevision -eq $MinRevisionStr)
{
    #YES
    #2̍ŌƂMAX̃rWƂĊmA^Oł
    Stamp-BuildTag $WebClient $MaxRevisionStr $OrientedBuildId
}
else
{
    #NO
    #RevisionŃp[\irh{
    Queue-PersonalBuild $WebClient $MiddleRevision $OrientedBuildId $OrientedBuildIdRevision $MaxRevisionStr $MinRevisionStr
}

