﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Get nact update file list.

    .DESCRIPTION
        Get nact update file list without actual build process.
#>

param
(
    # Diff file
    [parameter(mandatory=$true)]
    [string]
    $diffFile,

    # build config file
    [parameter(mandatory=$true)]
    [string]
    $buildConfigNames,

    # output file
    [parameter(mandatory=$true)]
    [string]
    $outputFile
)

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)

Import-Module "${scriptDirectoryPath}\Modules\Error"
Import-Module "${scriptDirectoryPath}\Modules\Path"

trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

# 結果保存用
$results = New-Object "System.Collections.Generic.List[string]" 

# Nact の Config ごとに処理
$configList = $buildConfigNames -csplit ","
$configList |% {
    # Nact が出力する差分リストファイル
    $intermediateResultsFile = $outputFile + "." + [System.IO.Path]::GetFileNameWithoutExtension($_) + ".txt"

    # Nact で差分リストを出力
    & $scriptDirectoryPath/Invoke-Script.ps1 Invoke-Nact $_ --assume_diff_files $diffFile --output_executed_rule_results $intermediateResultsFile assume-constant-revision=true
    if($LastExitCode -ne 0)
    {
        throw "Failed to get nact update file list."
    }

    # 結果を保存
    Get-Content $intermediateResultsFile |% {$results.Add([string]$_)}
    Remove-Item -Path $intermediateResultsFile
}

# 結果を出力ファイルに保存
Out-File -FilePath $outputFile -InputObject $results
exit $LastExitCode
