<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Dock and undock

    .DESCRIPTION
        Docks and undocks the SDEV.
#>

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)

Import-Module "${scriptDirectoryPath}\..\Modules\Path"

while (1)
{
    Write-Output "Docking..."
    & "$(Get-NintendoSdkRootPath)\Tools\CommandLineTools\ControlTarget.exe" enable-cradle
    Start-Sleep -s ${env:BGPROCESS_DELAY}
    Write-Output "Undocking..."
    & "$(Get-NintendoSdkRootPath)\Tools\CommandLineTools\ControlTarget.exe" disable-cradle
    Start-Sleep -s ${env:BGPROCESS_DELAY}
}
