:: ---------------------------------------------------------------------------
:: Copyright (C)2014 Nintendo Co., Ltd.  All rights reserved.
::
:: These coded instructions, statements, and computer programs contain
:: proprietary information of Nintendo of America Inc. and/or Nintendo
:: Company Ltd., and are protected by Federal copyright law.  They may
:: not be disclosed to third parties or copied or duplicated in any form,
:: in whole or in part, without the prior written consent of Nintendo.
:: ---------------------------------------------------------------------------

@echo off

setlocal

set SCRIPT_DIRECTORY=%~dp0
set REPOSITORY_ROOT=%~dp0\..\..\..\..\
set DOT_GIT_DIRECTORY=%REPOSITORY_ROOT%.git\

:: ---------------------------------------------------------------------------
:: Setup GitExternalScripts.
:: ---------------------------------------------------------------------------
echo Setup GitExternalScripts.

set EXSCRIPT_SRC_DIRECTORY=%SCRIPT_DIRECTORY%
set EXSCRIPT_DEST_DIRECTORY=%DOT_GIT_DIRECTORY%GitExternalScripts

if not exist "%EXSCRIPT_DEST_DIRECTORY%" (
    mkdir "%EXSCRIPT_DEST_DIRECTORY%"
)
xcopy /q /y /i "%EXSCRIPT_SRC_DIRECTORY%exBisectRunner.sh"      "%EXSCRIPT_DEST_DIRECTORY%" >nul

:: ---------------------------------------------------------------------------
:: Setup .git/config settings.
:: ---------------------------------------------------------------------------
echo Setup .git/config settings.
git config alias.exbisect "![ -z $2 ] && { echo 'Usage: git exbisect <commit> <script>'; echo 'For documentation, see http://spdlybra.nintendo.co.jp/confluence/x/LyCEBg'; exit 1; } || echo 'Initial bad commit:' && git log -1 --oneline && echo 'Initial good commit:' && git log -1 --oneline $1 && [ $? -eq 0 ] || { echo 'Revision invalid, exiting.'; exit 1; } && [ -f $2 ] || { echo 'Script invalid, exiting.'; exit 1; } && git exclean && git bisect start HEAD $1 -- && git bisect run .git/GitExternalScripts/exBisectRunner.sh $2 $3 $4 $5 $6 $7 $8 $9"
