﻿/*---------------------------------------------------------------------------*
  Copyright (C)2014 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/examplec/examplec_Api.h>
#include <nn/examplee/examplee_Api.h>
#include <nn/examplei/examplei_Api.h>

extern "C" void nnMain()
{
    nn::examplec::Initialize();
    nn::examplee::Initialize(); // nn::examplee::Initialize is overridden by ExampleI library.
    nn::examplei::Initialize();

    NN_LOG("ExampleTool nnMain()\n");

    nn::examplei::Finalize();
    nn::examplee::Finalize(); // nn::examplee::Finalize is overridden by ExampleI library.
    nn::examplec::Finalize();
}

