@echo off
:: Copyright (C)2016 Nintendo Co., Ltd.  All rights reserved.
:: 
:: These coded instructions, statements, and computer programs contain
:: proprietary information of Nintendo of America Inc. and/or Nintendo
:: Company Ltd., and are protected by Federal copyright law.  They may
:: not be disclosed to third parties or copied or duplicated in any form,
:: in whole or in part, without the prior written consent of Nintendo.

set PWD=%~dp0
echo Set "%PWD%" as a base path
call :REPLACE_PATH Integrate\Outputs\ProcessList\Release\NX-NXFP2-a32.txt
if ERRORLEVEL 1 goto FAILURE
call :REPLACE_PATH Integrate\Outputs\ProcessList\Release\NX-NXFP2-a64.txt
if ERRORLEVEL 1 goto FAILURE

:SUCCESS
echo;
echo --------------------------------------------------------------------
echo Default path in the process lists have been configured.
echo Please set SIGLO_BOOT_LIST_DIR to "%PWD%Integrate\Outputs\ProcessList\Release".
echo --------------------------------------------------------------------
exit 0

:FAILURE
echo Failed to configure path
exit 1

:: ---------------------------------------------------------------------------
:: REPLACE_PATH
:: Call powershell script to replace default path to current directory.
::
:: ---------------------------------------------------------------------------
:REPLACE_PATH
powershell -ExecutionPolicy RemoteSigned -Command "Set-Content %1 ((Get-Content %1) -replace '.*(Programs*)', '%PWD%$1')"
if %ERRORLEVEL% == 0 echo Configured %1
goto :EOF
