:: ---------------------------------------------------------------------------
:: Copyright (C)Nintendo Co., Ltd.  All rights reserved.
::
:: These coded instructions, statements, and computer programs contain
:: proprietary information of Nintendo of America Inc. and/or Nintendo
:: Company Ltd., and are protected by Federal copyright law.  They may
:: not be disclosed to third parties or copied or duplicated in any form,
:: in whole or in part, without the prior written consent of Nintendo.
:: ---------------------------------------------------------------------------

@echo off

:: Argument:
::   %1 ... SDK root directory path
::
:: Return Value:
::     0   - Success
::   101   - Not elevated (=Success)
::   other - Failure

set SDK_ROOT_DIR=%1

:: clear ERRORLEVEL
date /t>nul
:: Check administration
openfiles > NUL 2>&1
if %ERRORLEVEL% neq 0 (
    echo This script is not elevated.
    exit /b 101
)

call :SetWindowsFirewall
if not %ERRORLEVEL% equ 0 (
    exit /b %ERRORLEVEL%
)

exit /b 0





:: ͂Ȃ
:SetWindowsFirewall

set SET_FILES_1=%SDK_ROOT_DIR%\Resources\Firmwares\NX\OasisTM\NintendoTargetManager.exe
set SET_FILES_2=%SDK_ROOT_DIR%\Tools\CommandLineTools\InitializeSdevWin.exe
set SET_FILES_3=%SDK_ROOT_DIR%\Resources\Firmwares\NX\OasisTM\OldVersions\14483\NintendoTargetManager.exe

set RULE_NAME_1=Nintendo Target Manager
set RULE_NAME_2=InitializeSdevWin
set RULE_NAME_3=Nintendo Target Manager

netsh advfirewall firewall delete rule name="%RULE_NAME_1%" program="%SET_FILES_1%" > NUL 2>&1
netsh advfirewall firewall add rule name="%RULE_NAME_1%" dir=in action=block program="%SET_FILES_1%" profile=any protocol=tcp > NUL
netsh advfirewall firewall add rule name="%RULE_NAME_1%" dir=in action=block program="%SET_FILES_1%" profile=any protocol=udp > NUL

netsh advfirewall firewall delete rule name="%RULE_NAME_2%" program="%SET_FILES_2%" > NUL 2>&1
netsh advfirewall firewall add rule name="%RULE_NAME_2%" dir=in action=block program="%SET_FILES_2%" profile=any protocol=tcp > NUL
netsh advfirewall firewall add rule name="%RULE_NAME_2%" dir=in action=block program="%SET_FILES_2%" profile=any protocol=udp > NUL

netsh advfirewall firewall delete rule name="%RULE_NAME_3%" program="%SET_FILES_3%" > NUL 2>&1
netsh advfirewall firewall add rule name="%RULE_NAME_3%" dir=in action=block program="%SET_FILES_3%" profile=any protocol=tcp > NUL
netsh advfirewall firewall add rule name="%RULE_NAME_3%" dir=in action=block program="%SET_FILES_3%" profile=any protocol=udp > NUL

exit /b 0

