﻿/*
 *  Copyright 2005-2014 Acer Cloud Technology, Inc.
 *  All Rights Reserved.
 *
 *  This software contains confidential information and
 *  trade secrets of Acer Cloud Technology, Inc.
 *  Use, disclosure or reproduction is prohibited without
 *  the prior express written permission of Acer Cloud
 *  Technology, Inc.
 */

/*
 *               Copyright (C) 2010, BroadOn Communications Corp.
 *
 *  These coded instructions, statements, and computer programs contain
 *  unpublished proprietary information of BroadOn Communications Corp.,
 *  and are protected by federal copyright law. They may not be disclosed
 *  to third parties or copied or duplicated in any form, in whole or in
 *  part, without the prior written consent of BroadOn Communications Corp.
 *
 */


#ifndef __PUB_UTILS_H__
#define __PUB_UTILS_H__

#ifdef __EVL_API__
#include <iosc_compat.h>
#include <es_core.h>
#include <iosendian.h>
#else
#include <nn/iosc/iosc.h>
#include <nn/escorei/esi.h>
#include <nn/escorei/esitypes.h>
#endif
#include <nn/csl/csl.h>

#include <nn/ioslibc/ioslibc.h>
#include <nn/nn_SdkLog.h>

#define MIN(a,b)    (((a) < (b)) ? (a) : (b))

/*
 * Bit array manipulation
 */
static inline void
__bitSet(u8 *cp, u32 idx)
{
    cp[idx/8] |= 1 << (idx % 8);
}

static inline bool
__bitTest(u8 *cp, u32 idx)
{
    return (cp[idx/8] & 1 << (idx % 8)) != 0;
}


/*
 * Debug logging support
 */
#define PUB_DEBUG_CRIT               1
#define PUB_DEBUG_ERROR              2
#define PUB_DEBUG_WARN               4
#define PUB_DEBUG_INFO               8
#define PUB_DEBUG_NOTIFY             16
#define PUB_DEBUG_DEBUG              32
#define PUB_DEBUG_TRACE              64

#define PUB_DEBUG_LEVEL              0xF

#ifdef WIN32
    #ifdef _DEBUG
        #define PUB_DEBUG_LOG
    #endif
#else
    #define PUB_DEBUG_LOG
#endif

#ifdef PUB_DEBUG_LOG

#define pubLog(l, ...)                     \
    do {                                   \
        if (l & PUB_DEBUG_LEVEL) {         \
            NN_SDK_LOG("[PUB] " __VA_ARGS__);   \
        }                                  \
    } while (0)

#else

#define pubLog(l, ...)               (void)(0)

#endif  // PUB_DEBUG_LOG

#endif  // __PUB_UTILS_H__
