﻿/*
 *  Copyright 2005-2014 Acer Cloud Technology, Inc.
 *  All Rights Reserved.
 *
 *  This software contains confidential information and
 *  trade secrets of Acer Cloud Technology, Inc.
 *  Use, disclosure or reproduction is prohibited without
 *  the prior express written permission of Acer Cloud
 *  Technology, Inc.
 */

/*
 *               Copyright (C) 2009, BroadOn Communications Corp.
 *
 *  These coded instructions, statements, and computer programs contain
 *  unpublished  proprietary information of BroadOn Communications Corp.,
 *  and  are protected by Federal copyright law. They may not be disclosed
 *  to  third  parties or copied or duplicated in any form, in whole or in
 *  part, without the prior written consent of BroadOn Communications Corp.
 *
 */

#ifndef __ISTORAGE_H__
#define __ISTORAGE_H__

#include <nn/ioslibc/types.h>

#if defined(__cplusplus)

#include <ios>
#include <iostream>
#include <fstream>

/*
 * Define the Result class (used only by IStorage on linux)
 */
#define RESULT_NAMESPACE_START \
    namespace nn { \
    namespace escore {

#define RESULT_NAMESPACE_END \
    } }

#define RESULT_NAMESPACE nn::escore
#define USING_RESULT_NAMESPACE using namespace RESULT_NAMESPACE;
#define RESULT_NS(sym) RESULT_NAMESPACE::sym

RESULT_NAMESPACE_START

class Result
{
    private:
        s32 status;

    public:
        Result();
        ~Result();

        enum Module { MODULE_COMMON = 0 };

        void Set(s32 status);
        bool IsSuccess();
        bool IsFailure()  { return status != 0; }
        u32 GetSummary();
        u32 GetDescription() { return status; }
        Module GetModule()  { return MODULE_COMMON; }
        u32 GetPrintableBits()  { return 0; }
};

RESULT_NAMESPACE_END

#define ISTORAGE_NAMESPACE_START \
    namespace nn { \
    namespace escore { \
    namespace istorage {
#define ISTORAGE_NAMESPACE_END } } }
#define ISTORAGE_NAMESPACE nn::escore::istorage
#define USING_ISTORAGE_NAMESPACE \
    using namespace ISTORAGE_NAMESPACE;
#define ISTORAGE_SYM(sym) ISTORAGE_NAMESPACE::sym

ISTORAGE_NAMESPACE_START

class IInputStream
{
    public:
        virtual ~IInputStream() = 0;

        virtual Result TryRead(s32 *pOut, void *buffer, u32 size) = 0;
        virtual Result TrySetPosition(s64 position) = 0;
        virtual Result TryGetPosition(s64 *pOut) const = 0;
        virtual Result TryGetSize(s64 *pOut) const = 0;
};


class IOutputStream
{
    public:
        virtual ~IOutputStream() = 0;

        virtual Result TryWrite(s32 *pOut, const void *buffer, u32 size, bool flush=true) = 0;
        virtual Result TrySetPosition(s64 position) = 0;
        virtual Result TryGetPosition(s64 *pOut) const = 0;
        virtual Result TryGetSize(s64 *pOut) const = 0;
};

ISTORAGE_NAMESPACE_END


#else   // !__cplusplus

/* not C++ */
#define RESULT_NAMESPACE_START
#define RESULT_NAMESPACE_END
#define RESULT_NAMESPACE
#define USING_RESULT_NAMESPACE
#define RESULT_NS(sym) sym

#define ISTORAGE_NAMESPACE_START
#define ISTORAGE_NAMESPACE_END
#define ISTORAGE_NAMESPACE
#define USING_ISTORAGE_NAMESPACE
#define ISTORAGE_SYM(sym) sym


#endif  // !__cplusplus

#endif // __ISTORAGE_H__
