﻿/*
 *  Copyright 2005-2014 Acer Cloud Technology, Inc.
 *  All Rights Reserved.
 *
 *  This software contains confidential information and
 *  trade secrets of Acer Cloud Technology, Inc.
 *  Use, disclosure or reproduction is prohibited without
 *  the prior express written permission of Acer Cloud
 *  Technology, Inc.
 */

/*
 *               Copyright (C) 2010, BroadOn Communications Corp.
 *
 *  These coded instructions, statements, and computer programs contain
 *  unpublished  proprietary information of BroadOn Communications Corp.,
 *  and  are protected by Federal copyright law. They may not be disclosed
 *  to  third  parties or copied or duplicated in any form, in whole or in
 *  part, without the prior written consent of BroadOn Communications Corp.
 *
 */


#ifndef __IOSENDIAN_H__
#define __IOSENDIAN_H__

// Endianness conversion support
#define TRUNCATE_TO_U32(x)  ((u32)((x) & 0xffffffff))

#if defined(NN_BUILD_CONFIG_ENDIAN_BIG)
    #define htons(x)   (x)
    #define ntohs(x)   (x)
    #define htonl(x)   (x)
    #define ntohl(x)   (x)
    #define htonll(x)  (x)
    #define ntohll(x)  (x)
#else
    #define ntohs(x)   ((u16)((((x) & 0xff) << 8) | (((x) & 0xff00) >> 8)))
    #define ntohl(x)   ((((x) & 0xff) << 24) | (((x) & 0xff00) << 8) | (((x) & 0xff0000) >> 8) | (((x) & 0xff000000) >> 24))
    #define ntohll(x) ((u64)( ((u64)((ntohl(TRUNCATE_TO_U32(x)))) << 32) | (ntohl(TRUNCATE_TO_U32(((u64)(x))>>32))) ))
    #define htons(x)   ntohs(x)
    #define htonl(x)   ntohl(x)
    #define htonll(x)  ntohll(x)
#endif

#endif  // __IOSENDIAN_H__
