﻿/*
 *  Copyright 2005-2014 Acer Cloud Technology, Inc.
 *  All Rights Reserved.
 *
 *  This software contains confidential information and
 *  trade secrets of Acer Cloud Technology, Inc.
 *  Use, disclosure or reproduction is prohibited without
 *  the prior express written permission of Acer Cloud
 *  Technology, Inc.
 */

/*
 *  Copyright 2011 iGware, Inc.
 *  All Rights Reserved.
 *
 *  This software contains confidential information and
 *  trade secrets of iGware, Inc.
 *  Use, disclosure or reproduction is prohibited without
 *  the prior express written permission of iGware, Inc.
 */

/*
 *               Copyright (C) 2010, BroadOn Communications Corp.
 *
 *  These coded instructions, statements, and computer programs contain
 *  unpublished  proprietary information of BroadOn Communications Corp.,
 *  and  are protected by Federal copyright law. They may not be disclosed
 *  to  third  parties or copied or duplicated in any form, in whole or in
 *  part, without the prior written consent of BroadOn Communications Corp.
 *
 */


#ifndef __ESTYPES_H__
#define __ESTYPES_H__


#if defined(NN_PLATFORM_CTR) && !defined(IGWARE_ETD_BUILD)
#include <nn/drivers/es/CTR/types.h>
#include <nn/drivers/es/CTR/es_platform.h>
#else
#include <nn/ioslibc/types.h>
#include <nn/escore/es_platform.h>
#endif


// ES error codes
#define ES_ERR_OK                           0
#define ES_ERR_FAIL                         -1
#define ES_ERR_INVALID                      -2
#define ES_ERR_STORAGE                      -3
#define ES_ERR_STORAGE_SIZE                 -4
#define ES_ERR_CRYPTO                       -5
#define ES_ERR_VERIFICATION                 -6
#define ES_ERR_DEVICE_ID_MISMATCH           -7
#define ES_ERR_ISSUER_NOT_FOUND             -8
#define ES_ERR_INCORRECT_SIG_TYPE           -9
#define ES_ERR_INCORRECT_PUBKEY_TYPE        -10
#define ES_ERR_INCORRECT_TICKET_VERSION     -11
#define ES_ERR_INCORRECT_TMD_VERSION        -12
#define ES_ERR_NO_RIGHT                     -13
#define ES_ERR_ALIGNMENT                    -14

// ES error codes for certificate
#define ES_ERR_CERT_BASE                    -100
#define ES_ERR_CERT_FAIL                     ES_ERR_CERT_BASE + ES_ERR_FAIL
#define ES_ERR_CERT_INVALID                  ES_ERR_CERT_BASE + ES_ERR_INVALID
#define ES_ERR_CERT_STORAGE                  ES_ERR_CERT_BASE + ES_ERR_STORAGE
#define ES_ERR_CERT_STORAGE_SIZE             ES_ERR_CERT_BASE + ES_ERR_STORAGE_SIZE
#define ES_ERR_CERT_CRYPTO                   ES_ERR_CERT_BASE + ES_ERR_CRYPTO
#define ES_ERR_CERT_VERIFICATION             ES_ERR_CERT_BASE + ES_ERR_VERIFICATION
#define ES_ERR_CERT_DEVICE_ID_MISMATCH       ES_ERR_CERT_BASE + ES_ERR_DEVICE_ID_MISMATCH
#define ES_ERR_CERT_ISSUER_NOT_FOUND         ES_ERR_CERT_BASE + ES_ERR_ISSUER_NOT_FOUND
#define ES_ERR_CERT_INCORRECT_SIG_TYPE       ES_ERR_CERT_BASE + ES_ERR_INCORRECT_SIG_TYPE
#define ES_ERR_CERT_INCORRECT_PUBKEY_TYPE    ES_ERR_CERT_BASE + ES_ERR_INCORRECT_PUBKEY_TYPE
#define ES_ERR_CERT_INCORRECT_TICKET_VERSION ES_ERR_CERT_BASE + ES_ERR_INCORRECT_TICKET_VERSION
#define ES_ERR_CERT_INCORRECT_TMD_VERSION    ES_ERR_CERT_BASE + ES_ERR_INCORRECT_TMD_VERSION
#define ES_ERR_CERT_NO_RIGHT                 ES_ERR_CERT_BASE + ES_ERR_NO_RIGHT
#define ES_ERR_CERT_ALIGNMENT                ES_ERR_CERT_BASE + ES_ERR_ALIGNMENT

// ES signature types
#define ES_SIG_TYPE_ECC_SHA1                1
#define ES_SIG_TYPE_ECC_SHA256              2


// ES license types
#define ES_LICENSE_MASK                     0xf
#define ES_LICENSE_PERMANENT                0
#define ES_LICENSE_DEMO                     1
#define ES_LICENSE_TRIAL                    2
#define ES_LICENSE_RENTAL                   3
#define ES_LICENSE_SUBSCRIPTION             4
#define ES_LICENSE_SERVICE                  5

// ES title key types
#define ES_TITLE_KEY_TYPE_AES               0
#define ES_TITLE_KEY_TYPE_RSA2048           1
#define ES_TITLE_KEY_TYPE_ECC256            2


// ES title-level limit codes
#define ES_MAX_LIMIT_TYPE                   8

#define ES_LC_NO_LIMITS                     0
#define ES_LC_DURATION_TIME                 1
#define ES_LC_ABSOLUTE_TIME                 2
#define ES_LC_NUM_TITLES                    3
#define ES_LC_NUM_LAUNCH                    4
#define ES_LC_ELAPSED_TIME                  5


// ES item-level rights
#define ES_ITEM_RIGHT_PERMANENT             1
#define ES_ITEM_RIGHT_SUBSCRIPTION          2
#define ES_ITEM_RIGHT_CONTENT               3
#define ES_ITEM_RIGHT_CONTENT_CONSUMPTION   4
#define ES_ITEM_RIGHT_ACCESS_TITLE          5
#define ES_ITEM_RIGHT_LIMITED_RESOURCE      6

#define ES_REFERENCE_ID_LEN                 16
#define ES_CONTENT_ITEM_ACCESS_MASK_LEN     128


// ES title type
#define ES_TITLE_TYPE_DATA                  0x8
#define ES_TITLE_TYPE_CT_TITLE              0x40
#define ES_TITLE_TYPE_EV_TITLE              0x100


// ES content type
#define ES_CONTENT_TYPE_ENCRYPTED           0x1
#define ES_CONTENT_TYPE_DISC                0x2
#define ES_CONTENT_TYPE_CFM                 0x4
#define ES_CONTENT_TYPE_SHA1_HASH           0x2000
#define ES_CONTENT_TYPE_OPTIONAL            0x4000
#define ES_CONTENT_TYPE_SHARED              0x8000
#define ES_CONTENT_TYPE_HASHED              ES_CONTENT_TYPE_DISC


// Certificate and signature sizes
#define ES_DEVICE_CERT_SIZE                 384
#define ES_DEVICE_PRIVATE_KEY_SIZE          30
#define ES_SIGNING_CERT_SIZE                384
#define ES_SIGNATURE_SIZE                   60


// Size of custom data area in the TMD
#define ES_TMD_CUSTOM_DATA_LEN              32


//
// Maximum possible content index value is 64K - 2, since
// the maximum number of contents per title is 64K - 1
//
#define ES_CONTENT_INDEX_MAX                65534

ES_NAMESPACE_START

typedef s32 ESError;

typedef u32 ESV1DeviceId;
typedef u64 ESDeviceId;
typedef u64 ESTicketId;
typedef u64 ESTitleId;
typedef u8 ESRightsId[16];
typedef u32 ESAccountId;
typedef u32 ESContentId;
typedef u16 ESContentIndex;

typedef u16 ESTicketVersion;
typedef u16 ESTitleVersion;
typedef u16 ESMinorTitleVersion;
typedef ESTitleId ESSysVersion;

typedef u32 ESSigType;
typedef u8 ESLicenseType;
typedef u32 ESTitleType;
typedef u8 ESTitleKeyType;
typedef u16 ESContentType;
typedef u8 ESSysAccessMask[2];

typedef u8 ESAesKey[16];
typedef u8 ESRsaKey[256];

typedef struct {
    ESContentId     id;
    ESContentIndex  index;
    ESContentType   type;
    u64             size;
} ESContentInfo;


typedef u32 ESLimitCode;

typedef struct {
    ESLimitCode     code;
    u32             limit;
} ESLpEntry;


typedef u32 ESItemType;

typedef struct {
    u8              referenceId[ES_REFERENCE_ID_LEN];
    u32             referenceIdAttr;  // Reserved
} ESPermanentItemRight;

typedef struct {
    u32             limit;
    u8              referenceId[ES_REFERENCE_ID_LEN];
    u32             referenceIdAttr;  // Reserved
} ESSubscriptionItemRight;

typedef struct {
    ESContentIndex  offset;
    u8              accessMask[ES_CONTENT_ITEM_ACCESS_MASK_LEN];
} ESContentItemRight;

typedef struct {
    ESContentIndex  index;
    u16             padding;
    ESLimitCode     code;
    u32             limit;
} ESContentConsumptionItemRight;

typedef struct {
    u64             accessTitleId;
    u64             accessTitleMask;
} ESAccessTitleItemRight;

typedef struct {
    u32             limit;
    u8              referenceId[ES_REFERENCE_ID_LEN];
    u32             referenceIdAttr;
} ESLimitedResourceItemRight;

typedef struct {
    ESItemType      type;
    u32             padding;
    union {
        ESPermanentItemRight            perm;
        ESSubscriptionItemRight         sub;
        ESContentItemRight              cnt;
        ESContentConsumptionItemRight   cntLmt;
        ESAccessTitleItemRight          accTitle;
        ESLimitedResourceItemRight      limRes;

        u8                              padding[sizeof(ESContentItemRight) + 6];
    } right;
} ESItemRight;

typedef union {
    ESAesKey aesKey;
    ESRsaKey rsaKey;
} ESTitleKey;

ES_NAMESPACE_END

#endif // __ESTYPES_H__
