﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef __SHA256_H__
#define __SHA256_H__

#include <nn/ioslibc/types.h>

#ifdef __cplusplus
extern "C" {
#endif

#define SHA256_BLOCKSIZE    64
#define SHA256_DIGESTSIZE   32

typedef struct {
  u32 digest[8];           /* message digest */
  u32 count_lo, count_hi;  /* 64-bit bit count */
  u32 data[16];            /* SHA data buffer */
  u32 num, md_len;
} SHA256Context;

extern int SHA256Reset(SHA256Context* ctx);
extern int SHA256Input(SHA256Context* ctx, const u8 *buf, int len);
extern int SHA256Result(SHA256Context* ctx, u8 digest[SHA256_DIGESTSIZE]);

#ifdef __cplusplus
}
#endif

#endif /* __SHA256_H__ */
