﻿// 文字コード:UTF-8
/// @file
#pragma once

#include <lib/Vector2Pod.hpp>

//------------------------------------------------------------------------------
namespace lib {

/// @addtogroup LIB-Math
//@{
/// ２次元ベクトルのクラス版
class Vector2
    : public Vector2Pod
{
public:
    /// @name コンストラクタ。
    //@{
    inline Vector2();
    inline Vector2(float aX, float aY);
    inline Vector2(const Vector2Pod& aVec);
    //@}
};
//@}

//------------------------------------------------------------------------------
Vector2::Vector2()
{
    x = 0.0f;
    y = 0.0f;
}

//------------------------------------------------------------------------------
Vector2::Vector2(float aX, float aY)
{
    this->x = aX;
    this->y = aY;
}

//------------------------------------------------------------------------------
Vector2::Vector2(const Vector2Pod& aVec)
{
    this->x = aVec.x;
    this->y = aVec.y;
}
} // namespace
// EOF
