﻿// 文字コード:UTF-8
/// @file
#pragma once

//------------------------------------------------------------------------------
namespace lib {
/// コンパイル時にTFrom型がTTo型に変換できるか？を判定するトレイツ（特性）。
/// @details
/// C++11ではstd:isconvertible (in type_traits)として定義されているのと同様のもの。
/// * 使い方
/// @code
/// // ある型Typeが、intに変換できるか？をコンパイル時にチェックしたい。
/// LIB_COMPILER_ASSERT(TypeTraitsIsConvertible<Type, int>::Value);
/// @endcode
template<typename TFrom, typename TTo> struct TypeTraitsIsConvertible
{
private:
    /// struct False, struct Trueは、単にサイズの異なる構造体を定義したいだけ。
    struct False { char dummy[1]; };
    struct True  { char dummy[2]; };

    /// 関数オーバーロードを使って、TFromがTToに変換できるかを判定。
    static True  Is(TTo);
    static False Is(...);

    /// TFrom型のコンストラクタを実際に呼び出さずに済ますための偽関数。
    static TFrom CreateTFrom();

public:
    // LIBのenumのコーディングルールに違反しているが、enumであることは
    // 本質的ではなく、コンパイル時に定数であることを表現したいためだけなので
    // このようにしている。
    enum
    {
        /// このValueの値が、変換できるかの結果。値はtrueかfalse。
        Value = sizeof(Is(CreateTFrom())) == sizeof(True)
    };
};

} // namespace
// EOF
