﻿// 文字コード:UTF-8
/// @file
#pragma once

#include <type_traits>
#include "lib/DefaultDeleter.hpp"
#include "lib/NonCopyable.hpp"

//------------------------------------------------------------------------------
namespace lib {

template <class TPointee, class TDeleter = DefaultDeleter<TPointee>>
class ScopedPtr
    : private ::lib::NonCopyable
{
public:
    inline explicit ScopedPtr(TPointee* aPtr = nullptr);
    inline ~ScopedPtr();
    // 元のポインタは delete される
    inline void reset(TPointee* aPtr = nullptr);
    inline void swap(ScopedPtr* aPtr);
    inline TPointee& operator*() const;
    inline TPointee* operator->() const;
    inline TPointee* get() const;
    // 元のポインタは delete されず、戻り値として返される
    inline TPointee* release();
    inline bool isValid() const;
private:
    TPointee* mPtr;
};
//@}

//------------------------------------------------------------------------------
template <class TPointee, class TDeleter>
ScopedPtr<TPointee, TDeleter>::ScopedPtr(TPointee* const aPtr)
: mPtr(aPtr)
{
}

//------------------------------------------------------------------------------
template <class TPointee, class TDeleter>
ScopedPtr<TPointee, TDeleter>::~ScopedPtr()
{
    TDeleter::Delete(mPtr);
    mPtr = nullptr;
}

//------------------------------------------------------------------------------
template <class TPointee, class TDeleter>
void ScopedPtr<TPointee, TDeleter>::reset(TPointee* const aPtr)
{
    SYS_ASSERT(aPtr == nullptr || mPtr != aPtr);
    ScopedPtr tmp(aPtr);
    tmp.swap(this);
    // ここで、古いmPtrがdeleteされる
    {}
}

//------------------------------------------------------------------------------
template <class TPointee, class TDeleter>
void ScopedPtr<TPointee, TDeleter>::swap(ScopedPtr* aScopedPtr)
{
    SYS_ASSERT_POINTER(aScopedPtr);
    TPointee* const tmp = aScopedPtr->mPtr;
    aScopedPtr->mPtr = mPtr;
    mPtr = tmp;
}

//------------------------------------------------------------------------------
template <class TPointee, class TDeleter>
TPointee& ScopedPtr<TPointee, TDeleter>::operator*() const
{
    SYS_ASSERT(mPtr);
    return *mPtr;
}

//------------------------------------------------------------------------------
template <class TPointee, class TDeleter>
TPointee* ScopedPtr<TPointee, TDeleter>::operator->() const
{
    SYS_ASSERT(mPtr);
    return mPtr;
}

//------------------------------------------------------------------------------
template <class TPointee, class TDeleter>
TPointee* ScopedPtr<TPointee, TDeleter>::get() const
{
    return mPtr;
}

//------------------------------------------------------------------------------
template <class TPointee, class TDeleter>
TPointee* ScopedPtr<TPointee, TDeleter>::release()
{
    TPointee* ptr = mPtr;
    mPtr = 0;
    return ptr;
}

//------------------------------------------------------------------------------
template <class TPointee, class TDeleter>
bool ScopedPtr<TPointee, TDeleter>::isValid() const
{
    return mPtr != nullptr;
}

} // namespace
// EOF
