﻿// 文字コード:UTF-8
/// @file
#pragma once

#include <lib/NonCopyable.hpp>

//------------------------------------------------------------------------------
namespace lib {

//@{
/// 明示的に生成・解放できるシングルトン。
/// @details
/// ２つ以上インスタンス化させるとAssertに失敗して止まります。
template<typename TType>
class ProtectedSingleton
    : public ::lib::NonCopyable
{
public:
    inline ProtectedSingleton();
    inline ~ProtectedSingleton();

protected:
    inline static TType& Instance();    ///< インスタンスにアクセス。
    inline static bool Exists();       ///< 作り終わっているか。

    inline void SetInstance(TType* aRef);   ///< インスタンス化が終わったときに呼ぶ。
    inline void UnsetInstance();            ///< デストラクタで呼ぶ

private:
    static TType* mPtr;
};
//@}

//------------------------------------------------------------------------------
template<typename TType>
TType* ProtectedSingleton<TType>::mPtr = 0;

//------------------------------------------------------------------------------
template<typename TType>
ProtectedSingleton<TType>::ProtectedSingleton()
{
    LIB_ASSERT(!Exists());
}

//------------------------------------------------------------------------------
template<typename TType>
ProtectedSingleton<TType>::~ProtectedSingleton()
{
    LIB_ASSERT(!Exists());
}

//------------------------------------------------------------------------------
template<typename TType>
TType& ProtectedSingleton<TType>::Instance()
{
    LIB_ASSERT(Exists());
    return *mPtr;
}

//------------------------------------------------------------------------------
template<typename TType>
bool ProtectedSingleton<TType>::Exists()
{
    return mPtr != 0;
}

//------------------------------------------------------------------------------
template<typename TType>
void ProtectedSingleton<TType>::SetInstance(TType* aRef)
{
    LIB_ASSERT(!Exists());
    LIB_ASSERT_POINTER(aRef);
    mPtr = aRef;
}

//------------------------------------------------------------------------------
template<typename TType>
void ProtectedSingleton<TType>::UnsetInstance()
{
    LIB_ASSERT(Exists());
    mPtr = 0;
}

} // namespace
// EOF
