﻿// 文字コード:UTF-8
/// @file
#pragma once

//------------------------------------------------------------------------------
namespace lib {

/// コピー禁止のプレースホルダ
/// @details
/// コピーコンストラクタとコピー代入演算子をprivate宣言しているので、
/// このクラスをprivate継承するとコピー禁止になる。
class NonCopyable
{
protected:
    NonCopyable() {}
    ~NonCopyable() {}
private:
    /// コピーコンストラクタ
    NonCopyable(const NonCopyable&);
    /// コピー代入演算子
    NonCopyable& operator=(const NonCopyable&);
};
//@}

} // namespace
//------------------------------------------------------------------------------
// EOF
