﻿// 文字コード:UTF-8
/// @file
#pragma once

namespace lib {

// JSONを1パスで読み込む補助をします
class JsonReader
{
public:
    JsonReader(const char* aStr, int aStrSize);
    ~JsonReader();
    // 次をオブジェクト開始「{」とみなして読みます
    bool readObjectOpening();
    // 次をオブジェクト終了「}」とみなして読みます
    bool readObjectClosing();
    // 次を配列開始「[」とみなして読みます
    bool readArrayOpening();
    // 次を配列終了「]」とみなして読みます
    bool readArrayClosing();
    // 次をオブジェクトのキーとみなして読みます
    bool readKey(char* aStr, int aStrCap);
    // 次を「int」値とみなして読みます
    bool readInt(int* aValue);
    // 次を「float」値とみなして読みます
    bool readFloat(float* aValue);
    // 次を「bool」値とみなして読みます
    bool readBool(bool* aValue);
    // 次を「char[]」値とみなして読みます
    bool readString(char* aStr, int aStrCap);
    // 次を何らかの値・オブジェクト・配列とみなして読み進めます
    bool readValue(const char** aStartPos = nullptr, const char** aEndPos = nullptr);

    // 現在読んでいる位置
    const char* currentPosition() const { return mBuf + mBufIndex; }

private:
    bool readIdentifier(char* aStr, int aStrCap);
    bool readObject();
    bool readArray();
    void readUnnecessaryCharsAndComment();
    bool readSpecifiedChar(const char aChar);
    bool readSpecifiedString(const char* aStr);
    const char *mBuf;
    int mBufSize;
    int mBufIndex;
};

} // namespace
// EOF
