﻿// 文字コード:UTF-8
/// @file
#include "InternalArgsUnitTest.hpp"

#include "InternalArgs.hpp"
#include "SplitCommand.hpp"
#include "sys/account/Account.hpp"

//------------------------------------------------------------------------------
void InternalArgsUnitTest::UnitTest()
{
    // 有効なオプションが一つもない場合無効となるか
    {
        const char* args[] = {
            "null",
        };
        auto count = sizeof(args) / sizeof(args[0]);
        SplitCommand splitCmd(count, reinterpret_cast<char**>(&args));
        InternalArgs internalArgs(splitCmd);
        SYS_ASSERT(!internalArgs.isValid());
    }

    // WebApplet最低限の引数を与えて有効となるか
    {
        const char* args[] = {
            "null",
            "web", "http://www.nintendo.com"
        };
        auto count = sizeof(args) / sizeof(args[0]);
        SplitCommand splitCmd(count, reinterpret_cast<char**>(&args));
        InternalArgs internalArgs(splitCmd);
        SYS_ASSERT(internalArgs.showAppletKind() == ::InternalArgs::ShowAppletKind::Web && internalArgs.isValid());
    }

    // OfflineApplet最低限の引数を与えて有効となるか
    {
        const char* args[] = {
            "null",
            "offline", "debug://sample.htdocs/index.html",
        };
        auto count = sizeof(args) / sizeof(args[0]);
        SplitCommand splitCmd(count, reinterpret_cast<char**>(&args));
        InternalArgs internalArgs(splitCmd);
        SYS_ASSERT(internalArgs.showAppletKind() == ::InternalArgs::ShowAppletKind::Offline && internalArgs.isValid());
    }

    // Url, CallBackUrl, CallbackableUrl UserAgentAdditionalString 欠落テスト
    {
        const char* args[] = {
            "null",
            "web", "http://shrub.hallab.co.jp/projects/cruiser/test/browse/url/url1025.html?a=0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000END",
            "--callback-url", "http://shrub.hallab.co.jp/projects/cruiser/test/browse/url/url1025.html?a=00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000END",
            "--callbackable-url", "http://shrub.hallab.co.jp/projects/cruiser/test/browse/url/url1025.html?a=00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000END",
            "--user-agent-additional-string", "TestAgent/1.0.01234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789.END"
        };
        auto count = sizeof(args) / sizeof(args[0]);
        SplitCommand splitCmd(count, reinterpret_cast<char**>(&args));
        InternalArgs internalArgs(splitCmd);
        SYS_ASSERT(internalArgs.showAppletKind() == ::InternalArgs::ShowAppletKind::Web && internalArgs.isValid());
        SYS_ASSERT(internalArgs.requestUrl().getLength() == ::nn::web::ShowWebPageArg::RequestUrlMaxLength - 1);
        SYS_ASSERT(internalArgs.callbackUrl().getLength() == ::nn::web::ShowWebPageArg::CallbackUrlMaxLength - 1);
        SYS_ASSERT(internalArgs.callbackableUrl().getLength() == ::nn::web::ShowWebPageArg::CallbackableUrlMaxLength - 1);
        SYS_ASSERT(internalArgs.userAgentAdditionalString().getLength() == ::nn::web::ShowWebPageArg::UserAgentAdditionalStringMaxLength - 1);
    }

    // Documentpath 欠落テスト
    {
        const char* args[] = {
            "null",
            "offline", "http://shrub.hallab.co.jp/projects/cruiser/test/browse/url/url1025.html?a=0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000END",
        };
        auto count = sizeof(args) / sizeof(args[0]);
        SplitCommand splitCmd(count, reinterpret_cast<char**>(&args));
        InternalArgs internalArgs(splitCmd);
        SYS_ASSERT(internalArgs.showAppletKind() == ::InternalArgs::ShowAppletKind::Offline && internalArgs.isValid());
        SYS_ASSERT(internalArgs.documentPath().getLength() == ::nn::web::ShowOfflineHtmlPageArg::DocumentPathMaxLength - 1);
    }

    // WebApplet利用可能な引数テスト
    {
        const char* args[] = {
            "null",
            "web", "http://www.nintendo.com",
            "--boot-as-media-player", "true",
            "--media-player-auto-close-enabled", "true",
            "--web-audio-enabled", "true",
            "--callback-url", "http://www.nintendo.com/callback",
            "--callbackable-url", "http://www.nintendo.com/callbackable",
            "--pointer-enabled", "false",
            "--left-stick-mode", "SpatialNavi",
            "--user-index", "0",
            "--background-kind", "ApplicationCapture",
            "--boot-display-kind", "Black",
            "--js-extension-enabled", "true",
            "--display-url-kind", "Domain",
            "--user-agent-additional-string", "TestAgent/1.0",
            "--touch-enabled-on-contents", "false",
            "--page-cache-enabled", "false",
            "--footer-fixed-kind",  "Shown",
            "--page-fade-enabled", "false",
            "--page-scroll-indicator-enabled", "true",
            "--media-player-speed-control-enabled", "true",
        };
        auto count = sizeof(args) / sizeof(args[0]);
        SplitCommand splitCmd(count, reinterpret_cast<char**>(&args));
        InternalArgs internalArgs(splitCmd);
        SYS_ASSERT(internalArgs.isValid());
        SYS_ASSERT(internalArgs.showAppletKind() == ::InternalArgs::ShowAppletKind::Web);
        SYS_ASSERT(internalArgs.isBootAsMediaPlayer());
        SYS_ASSERT(internalArgs.isMediaPlayerAutoCloseEnabled());
        SYS_ASSERT(internalArgs.isWebAudioEnabled());
        SYS_ASSERT(!internalArgs.callbackUrl().isEmpty());
        SYS_ASSERT(!internalArgs.callbackableUrl().isEmpty());
        SYS_ASSERT(!internalArgs.isPointerEnabled());
        SYS_ASSERT(internalArgs.leftStickMode() == ::nn::web::common::LeftStickMode::SpatialNavi);
        if (::sys::account::Account::Instance().userCount() > 0) {
            SYS_ASSERT(internalArgs.uid() != ::nn::account::InvalidUid);
        }
        else {
            SYS_ASSERT(internalArgs.uid() == ::nn::account::InvalidUid);
        }
        SYS_ASSERT(internalArgs.backgroundKind() == ::nn::web::common::BackgroundKind::ApplicationCapture);
        SYS_ASSERT(internalArgs.bootDisplayKind() == ::nn::web::common::BootDisplayKind::Black);
        SYS_ASSERT(internalArgs.isJsExtensionEnabled());
        SYS_ASSERT(internalArgs.displayUrlKind() == ::InternalArgs::DisplayUrlKind::Domain);
        SYS_ASSERT(!internalArgs.userAgentAdditionalString().isEmpty());
        SYS_ASSERT(!internalArgs.isTouchEnabledOnContents());
        SYS_ASSERT(!internalArgs.isPageCacheEnabled());
        SYS_ASSERT(internalArgs.footerFixedKind() == ::nn::web::common::FooterFixedKind::Shown);
        SYS_ASSERT(!internalArgs.isPageFadeEnabled());
        SYS_ASSERT(internalArgs.isPageScrollIndicatorEnabled());
        SYS_ASSERT(internalArgs.isMediaPlayerSpeedControlEnabled());
    }

    // 無効なUidが渡されても問題ないか
    {
        const char* args[] = {
            "null",
            "web", "http://www.nintendo.com",
            "--user-index", "256",
        };
        auto count = sizeof(args) / sizeof(args[0]);
        SplitCommand splitCmd(count, reinterpret_cast<char**>(&args));
        InternalArgs internalArgs(splitCmd);
        SYS_ASSERT(internalArgs.uid() == ::nn::account::InvalidUid);
    }

    // OfflineApplet利用可能な引数テスト
    {
        const char* args[] = {
            "null",
            "offline", "debug://sample.htdocs/index.html",
            "--boot-as-media-player", "true",
            "--media-player-auto-close-enabled", "true",
            "--web-audio-enabled", "true",
            "--pointer-enabled", "false",
            "--left-stick-mode", "StickPointer",
            "--footer-enabled", "false",
            "--background-kind", "ApplicationCaptureBlur",
            "--boot-display-kind", "White",
            "--key-repeat-delay-frame", "5",
            "--key-repeat-pulse-frame", "3",
            "--js-extension-enabled", "true",
            "--touch-enabled-on-contents", "false",
            "--page-cache-enabled", "false",
            "--footer-fixed-kind",  "Shown",
            "--page-fade-enabled", "false",
            "--boot-loading-icon-enabled", "false",
            "--page-scroll-indicator-enabled", "true",
            "--media-player-speed-control-enabled", "true",
        };
        auto count = sizeof(args) / sizeof(args[0]);
        SplitCommand splitCmd(count, reinterpret_cast<char**>(&args));
        InternalArgs internalArgs(splitCmd);
        SYS_ASSERT(internalArgs.isValid());
        SYS_ASSERT(internalArgs.showAppletKind() == ::InternalArgs::ShowAppletKind::Offline);
        SYS_ASSERT(internalArgs.isBootAsMediaPlayer());
        SYS_ASSERT(internalArgs.isMediaPlayerAutoCloseEnabled());
        SYS_ASSERT(internalArgs.isWebAudioEnabled());
        SYS_ASSERT(!internalArgs.isPointerEnabled());
        SYS_ASSERT(internalArgs.leftStickMode() == ::nn::web::common::LeftStickMode::StickPointer);
        SYS_ASSERT(!internalArgs.isFooterEnabled());
        SYS_ASSERT(internalArgs.backgroundKind() == ::nn::web::common::BackgroundKind::ApplicationCaptureBlur);
        SYS_ASSERT(internalArgs.bootDisplayKind() == ::nn::web::common::BootDisplayKind::White);
        SYS_ASSERT(internalArgs.keyRepeatDelayFrame() == 5);
        SYS_ASSERT(internalArgs.keyRepeatPulseFrame() == 3);
        SYS_ASSERT(internalArgs.isJsExtensionEnabled());
        SYS_ASSERT(!internalArgs.isTouchEnabledOnContents());
        SYS_ASSERT(!internalArgs.isPageCacheEnabled());
        SYS_ASSERT(internalArgs.footerFixedKind() == ::nn::web::common::FooterFixedKind::Shown);
        SYS_ASSERT(!internalArgs.isPageFadeEnabled());
        SYS_ASSERT(!internalArgs.isBootLoadingIconEnabled());
        SYS_ASSERT(internalArgs.isPageScrollIndicatorEnabled());
        SYS_ASSERT(internalArgs.isMediaPlayerSpeedControlEnabled());
    }

    // OfflineApplet ドキュメントパスにdebug://が無くても補完されるか
    {
        const char* args[] = {
            "null",
            "offline", "sample.htdocs/index.html",
        };
        auto count = sizeof(args) / sizeof(args[0]);
        SplitCommand splitCmd(count, reinterpret_cast<char**>(&args));
        InternalArgs internalArgs(splitCmd);
        SYS_ASSERT(internalArgs.showAppletKind() == ::InternalArgs::ShowAppletKind::Offline && internalArgs.isValid());
        SYS_ASSERT(std::strcmp(internalArgs.documentPath().buffer(), "debug://sample.htdocs/index.html") == 0);
    }

    // --helpを拾えるか
    {
        const char* args[] = {
            "null",
            "--help"
        };
        auto count = sizeof(args) / sizeof(args[0]);
        SplitCommand splitCmd(count, reinterpret_cast<char**>(&args));
        InternalArgs internalArgs(splitCmd);
        SYS_ASSERT(internalArgs.displayHelpKind() == InternalArgs::DisplayHelpKind::Common);
    }

    // WebApplet --helpを拾えるか
    {
        const char* args[] = {
            "null",
            "web",
            "--help"
        };
        auto count = sizeof(args) / sizeof(args[0]);
        SplitCommand splitCmd(count, reinterpret_cast<char**>(&args));
        InternalArgs internalArgs(splitCmd);
        SYS_ASSERT(internalArgs.displayHelpKind() == InternalArgs::DisplayHelpKind::Web);
    }

    // OfflineApplet --helpを拾えるか
    {
        const char* args[] = {
            "null",
            "offline",
            "--help"
        };
        auto count = sizeof(args) / sizeof(args[0]);
        SplitCommand splitCmd(count, reinterpret_cast<char**>(&args));
        InternalArgs internalArgs(splitCmd);
        SYS_ASSERT(internalArgs.displayHelpKind() == InternalArgs::DisplayHelpKind::Offline);
    }

    // WebApplet web のみが渡された場合ヘルプ表示となるか
    {
        const char* args[] = {
            "null",
            "web",
        };
        auto count = sizeof(args) / sizeof(args[0]);
        SplitCommand splitCmd(count, reinterpret_cast<char**>(&args));
        InternalArgs internalArgs(splitCmd);
        SYS_ASSERT(internalArgs.displayHelpKind() == InternalArgs::DisplayHelpKind::Web);
        SYS_ASSERT(splitCmd.requiresHelp());
    }

    // OfflineApplet offline のみが渡された場合ヘルプ表示となるか
    {
        const char* args[] = {
            "null",
            "offline",
        };
        auto count = sizeof(args) / sizeof(args[0]);
        SplitCommand splitCmd(count, reinterpret_cast<char**>(&args));
        InternalArgs internalArgs(splitCmd);
        SYS_ASSERT(internalArgs.displayHelpKind() == InternalArgs::DisplayHelpKind::Offline);
        SYS_ASSERT(splitCmd.requiresHelp());
    }
}

//------------------------------------------------------------------------------
// EOF
