﻿/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include <nn/os.h>
#include <nn/nn_Abort.h>
#include <nn/nn_SdkLog.h>
#include <cstdlib>

extern "C" {

#include <sys/types.h>
#include <sys/param.h>
#include <sys/libkern.h>
#include <sys/random.h>

struct harvest_select harvest;

u_long random()
{
    return std::rand();
}

int read_random(void *buffer, int size)
{
    int i = 0;
    u_long val = 0;

    if (buffer == nullptr) {
        return 0;
    }

    if (size <= 0) {
        return size;
    }

    for (; i <= (size - sizeof(val)); i += sizeof(val)) {
        val = std::rand();
        memcpy(&((uint8_t*)buffer)[i], &val, sizeof(val));
    }

    val = std::rand();
    memcpy(&((uint8_t*)buffer)[i], &val, (size % sizeof(val)));

    return size;
}

void random_harvest(void *entropy, u_int size, u_int bits, enum esource d)
{
    //We have our own methods to generate randomness, and would rather not
    //rely on anything from the network, so this function is unimplemented.
    (void)entropy;
    (void)size;
    (void)bits;
    (void)d;
}

}

