﻿/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include <nn/os.h>
#include <nn/nn_Abort.h>
#include <nn/nn_SdkLog.h>
#include <cstring>
#include <cstdarg>

extern "C" {

#include <sys/param.h>
#include <sys/systm.h>
#include <sys/jail.h>
#include <sys/ucred.h>
#include <netinet/in.h>

/*
 * Check if given address belongs to the jail referenced by cred (wrapper to
 * prison_check_ip[46]).
 *
 * Returns 0 if jail doesn't restrict the address family or if address belongs
 * to jail, EADDRNOTAVAIL if the address doesn't belong, or EAFNOSUPPORT if
 * the jail doesn't allow the address family.  IPv4 Address passed in in NBO.
 */
int prison_if(struct ucred *cred, struct sockaddr *sa)
{
    STUB_WARNING();
    return 0;
}

/*
 * Check if a jail supports the given address family.
 *
 * Returns 0 if not jailed or the address family is supported, EAFNOSUPPORT
 * if not.
 */
int prison_check_af(struct ucred *cred, int af)
{
    STUB_WARNING();
    return 0;
}

/*
 * Return true if pr1 and pr2 have the same IPv4 address restrictions.
 */
int prison_equal_ip4(struct prison *pr, struct prison *ia)
{
    STUB_WARNING();
    return 1;
}

/*
 * Pass back primary IPv4 address of this jail.
 *
 * If not restricted return success but do not alter the address.  Caller has
 * to make sure to initialize it correctly (e.g. INADDR_ANY).
 *
 * Returns 0 on success, EAFNOSUPPORT if the jail doesn't allow IPv4.
 * Address returned in NBO.
 */
int prison_get_ip4(struct ucred *cred, struct in_addr *ia)
{
    STUB_WARNING();
    return 0;
}

/*
 * Make sure our (source) address is set to something meaningful to this
 * jail.
 *
 * Returns 0 if jail doesn't restrict IPv4 or if address belongs to jail,
 * EADDRNOTAVAIL if the address doesn't belong, or EAFNOSUPPORT if the jail
 * doesn't allow IPv4.  Address passed in in NBO and returned in NBO.
 */
int prison_local_ip4(struct ucred *cred, struct in_addr *ia)
{
    STUB_WARNING();
    return 0;
}

/*
 * Rewrite destination address in case we will connect to loopback address.
 *
 * Returns 0 on success, EAFNOSUPPORT if the jail doesn't allow IPv4.
 * Address passed in in NBO and returned in NBO.
 */
int prison_remote_ip4(struct ucred *cred, struct in_addr *ia)
{
    STUB_WARNING();
    return 0;
}

/*
 * Check if given address belongs to the jail referenced by cred/prison.
 *
 * Returns 0 if jail doesn't restrict IPv4 or if address belongs to jail,
 * EADDRNOTAVAIL if the address doesn't belong, or EAFNOSUPPORT if the jail
 * doesn't allow IPv4.  Address passed in in NBO.
 */
int prison_check_ip4(struct ucred *cred, struct in_addr *ia)
{
    STUB_WARNING();
    return 0;
}

/*
 * Return 1 if we should do proper source address selection or are not jailed.
 * We will return 0 if we should bypass source address selection in favour
 * of the primary jail IPv4 address. Only in this case *ia will be updated and
 * returned in NBO.
 * Return EAFNOSUPPORT, in case this jail does not allow IPv4.
 */
int prison_saddrsel_ip4(struct ucred *cred, struct in_addr *ia)
{
    STUB_WARNING();
    return 1;
}

/*
 * Return true if pr1 and pr2 have the same IPv6 address restrictions.
 */
int prison_equal_ip6(struct prison *cred, struct prison *ia)
{
    STUB_WARNING();
    return 1;
}

/*
 * Pass back primary IPv6 address for this jail.
 *
 * If not restricted return success but do not alter the address.  Caller has
 * to make sure to initialize it correctly (e.g. IN6ADDR_ANY_INIT).
 *
 * Returns 0 on success, EAFNOSUPPORT if the jail doesn't allow IPv6.
 */
int prison_get_ip6(struct ucred *cred, struct in6_addr *ia)
{
    STUB_WARNING();
    return 0;
}

/*
 * Make sure our (source) address is set to something meaningful to this jail.
 *
 * v6only should be set based on (inp->inp_flags & IN6P_IPV6_V6ONLY != 0)
 * when needed while binding.
 *
 * Returns 0 if jail doesn't restrict IPv6 or if address belongs to jail,
 * EADDRNOTAVAIL if the address doesn't belong, or EAFNOSUPPORT if the jail
 * doesn't allow IPv6.
 */
int prison_local_ip6(struct ucred *cred, struct in6_addr *ia, int s)
{
    STUB_WARNING();
    return 0;
}

/*
 * Rewrite destination address in case we will connect to loopback address.
 *
 * Returns 0 on success, EAFNOSUPPORT if the jail doesn't allow IPv6.
 */
int prison_remote_ip6(struct ucred *cred, struct in6_addr *ia)
{
    STUB_WARNING();
    return 0;
}

/*
 * Check if given address belongs to the jail referenced by cred/prison.
 *
 * Returns 0 if jail doesn't restrict IPv6 or if address belongs to jail,
 * EADDRNOTAVAIL if the address doesn't belong, or EAFNOSUPPORT if the jail
 * doesn't allow IPv6.
 */
int prison_check_ip6(struct ucred *cred, struct in6_addr *ia)
{
    STUB_WARNING();
    return 0;
}

/*
 * Return 1 if we should do proper source address selection or are not jailed.
 * We will return 0 if we should bypass source address selection in favour
 * of the primary jail IPv6 address. Only in this case *ia will be updated and
 * returned in NBO.
 * Return EAFNOSUPPORT, in case this jail does not allow IPv6.
 */
int prison_saddrsel_ip6(struct ucred *cred, struct in6_addr *ia)
{
    STUB_WARNING();
    return 1;
}

/*
 * See if a prison has the specific flag set.
 */
int prison_flag(struct ucred *cred, unsigned flag)
{
    return (cred->cr_prison->pr_flags & flag);
}

/*
 * Return 1 if the passed credential is in a jail and that jail does not
 * have its own virtual network stack, otherwise 0.
 */
int jailed_without_vnet(struct ucred *cred)
{
    STUB_WARNING();
    return 0;
}

/*
 * Return 1 if the passed credential is in a jail, otherwise 0.
 */
int jailed(struct ucred *cred)
{
    STUB_WARNING();
    return 0;
}

}
