﻿/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include <nn/os.h>
#include <nn/nn_Abort.h>
#include <nn/nn_SdkLog.h>

extern "C" {

#include <sys/types.h>
#include <sys/param.h>
#include <sys/kernel.h>
#include <sys/libkern.h>
#include <sys/socket.h>
#include <sys/file.h>
#include <sys/filedesc.h>
#include <siglo/idtab.h>

static int idlastused(struct filedesc* fdp, int size)
{
    int id;

    NDSLOTTYPE* idtab_mask = fdp->fd_map;
    for (id = size; id >= 0; --id) {
        if(get_field(idtab_mask, id) != 0){
            break;
        }
    }
    return id;
}

int idalloc(struct filedesc* fdp)
{
    int id;
    int fd = -1;
    NDSLOTTYPE* idtab_mask = fdp->fd_map;
    for (id = 0; id < maxfilesperproc; id++) {
        if (get_field(idtab_mask, id) == 0) {
            set_field(idtab_mask, id);

            if (fdp->fd_lastfile < id){
                fdp->fd_lastfile = id;
            }
            fd = id;
            fdp->fd_nfiles++;
            goto out;
        }
    }

out:
    return fd;
}

void idfree(struct filedesc* fdp, int fd)
{
    NDSLOTTYPE* idtab_mask = fdp->fd_map;
    if (fd >= 0 && fd <= fdp->fd_lastfile) {
        clr_field(idtab_mask, fd);

        if (fdp->fd_lastfile == fd)
            fdp->fd_lastfile = idlastused(fdp, fd);

        fdp->fd_freefile = fd;
        fdp->fd_nfiles--;
    }
    return;
}

}
