﻿/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#ifndef __SIGLO_BSD_H__
#define __SIGLO_BSD_H__

#ifdef _KERNEL

#define malloc    siglo_malloc
#define free      siglo_free
#define memalign  siglo_memalign
#define realloc   siglo_realloc
#define reallocf  siglo_reallocf
#define _sbrk_r   siglo_sbrk
#define printf    siglo_printf
#define snprintf  siglo_snprintf
#define random    siglo_random

#define FORCE_LINK_THIS(x)  int force_link_##x = 0;
#define FORCE_LINK_THAT(x)  extern int force_link_##x; int ret_link_##x = force_link_##x;

#define SENDMMSG_MAX_MSGS    32

#endif
#endif
