﻿
#ifndef _BSD_MACHINE_ATOMIC_H_
#define _BSD_MACHINE_ATOMIC_H_

#include <sys/types.h>

#define atomic_cmpset_32(p, c, v)          ({uint32_t val = (v); uint32_t cmp = (c); __atomic_compare_exchange((p), &cmp, &val, 1, __ATOMIC_SEQ_CST, __ATOMIC_RELAXED); })
#define atomic_cmpset_acq_32(p, c, v)      ({uint32_t val = (v); uint32_t cmp = (c); __atomic_compare_exchange((p), &cmp, &val, 1, __ATOMIC_SEQ_CST, __ATOMIC_RELAXED); })
#define atomic_cmpset_int(p, c, v)         ({int val = (int)(v); int cmp = (int)(c); __atomic_compare_exchange((int*)(p), &cmp, &val, 1, __ATOMIC_SEQ_CST, __ATOMIC_RELAXED); })
#define atomic_cmpset_acq_int(p, c, v)     ({int val = (int)(v); int cmp = (int)(c); __atomic_compare_exchange((int*)(p), &cmp, &val, 1, __ATOMIC_SEQ_CST, __ATOMIC_RELAXED); })
#define atomic_store_rel_32(p, v)           do {uint32_t val = (v); __atomic_store((p), &val, __ATOMIC_RELAXED); } while (0)
#define atomic_store_rel_int(p, v)          do {int val = (int)(v); __atomic_store((int*)(p), &val, __ATOMIC_RELAXED); } while (0)
#define atomic_add_32(p, v)                 __atomic_add_fetch((p), (v), __ATOMIC_RELAXED)
#define atomic_add_rel_32(p, v)             __atomic_add_fetch((p), (v), __ATOMIC_RELAXED)
#define atomic_add_acq_32(p, v)             __atomic_add_fetch((p), (v), __ATOMIC_RELAXED)
#define atomic_add_long(p, v)               __atomic_add_fetch((p), (v), __ATOMIC_RELAXED)
#define atomic_add_int(p, v)                __atomic_add_fetch((p), (v), __ATOMIC_RELAXED)
#define atomic_add_acq_int(p, v)            __atomic_add_fetch((p), (v), __ATOMIC_RELAXED)
#define atomic_add_rel_int(p, v)            __atomic_add_fetch((p), (v), __ATOMIC_RELAXED)
#define atomic_subtract_32(p, v)            __atomic_sub_fetch((p), (v), __ATOMIC_RELAXED)
#define atomic_subtract_int(p, v)           __atomic_sub_fetch((p), (v), __ATOMIC_RELAXED)
#define atomic_subtract_long(p, v)          __atomic_sub_fetch((p), (v), __ATOMIC_RELAXED)
#define atomic_fetchadd_32(p, v)            __atomic_fetch_add((p), (v), __ATOMIC_RELAXED)
#define atomic_fetchadd_long(p, v)          __atomic_fetch_add((p), (v), __ATOMIC_RELAXED)
#define atomic_fetchadd_int(p, v)           __atomic_fetch_add((p), (v), __ATOMIC_RELAXED)
#define atomic_set_int(p, v)                __atomic_or_fetch((p),  (v), __ATOMIC_RELAXED)
#define atomic_clear_int(p, v)              __atomic_and_fetch((p), ~(v), __ATOMIC_RELAXED)
#define rmb()                               __atomic_thread_fence(__ATOMIC_SEQ_CST)

#endif /* _BSD_MACHINE_ATOMIC_H_ */
