﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>
#include <cstdint>
#include <cstddef>
#include <cstdlib>
#include <thread>
#include <climits>
#include <pthread.h>
#include "ntd-test-tls.h"

/* RYNDA-731 */

extern void *__dso_handle;  // this is defined in Chris/Sources/Libraries/rocrt/rocrt.cpp

#define TEST_ROOT_NAME STRINGIZE_VALUE_OF(TLS_TEST_NAME)
#if ULONG_MAX == 0xffffffff
#define TEST_NAME "ARM32-" TEST_ROOT_NAME
#else
#define TEST_NAME "AARCH64-" TEST_ROOT_NAME
#endif

static int num_ThreadLocalDestructorCalls = 0;
static int num_TestDestructorCalls = 0;
struct ThreadLocal
{
    long ThreadLocal_num_dtrs_to_call;
    ~ThreadLocal()
    {
        TESTLOG("In ~ThreadLocal().");
        ThreadLocal_num_dtrs_to_call = __nnmusl_get_tls_dtors_status (__dso_handle);
        TESTLOG("There are %ld registered destructors at the end of ~ThreadLocal().", ThreadLocal_num_dtrs_to_call);
        TESTCASE_MESSAGE(ThreadLocal_num_dtrs_to_call == 1, "Before exiting ~ThreadLocal() we expected 2 uncalled Destructors but we got %ld.",
            ThreadLocal_num_dtrs_to_call);
        num_ThreadLocalDestructorCalls++;
    }
};

struct Test
{
    long Test_num_dtrs_to_call;
    ~Test()
    {
        Test_num_dtrs_to_call = __nnmusl_get_tls_dtors_status (__dso_handle);
        TESTLOG("There are %ld registered destructors at the beginning of ~Test() (before constructing ThreadLocal obj).", Test_num_dtrs_to_call);
        TESTCASE_MESSAGE(Test_num_dtrs_to_call == 1, "In ~Test() before constructing ThreadLocal obj, we expected 1 uncalled Destructor but we got %ld.",
            Test_num_dtrs_to_call);
        TESTLOG("Construct the ThreadLocal obj that calls __cxa_thread_atexit_impl to register ~ThreadLocal.");
        thread_local ThreadLocal obj;
        TESTLOG("Construction of ThreadLocal obj complete.");
        Test_num_dtrs_to_call = __nnmusl_get_tls_dtors_status (__dso_handle);
        TESTLOG("There are %ld registered destructors at the end of ~Test() (after construction of ThreadLocal obj).", Test_num_dtrs_to_call);
        TESTCASE_MESSAGE(Test_num_dtrs_to_call == 2, "Before exiting ~Test() (after construction of ThreadLocal obj) we expected 2 uncalled Destructor but we got %ld.",
            Test_num_dtrs_to_call);
        TESTLOG("Expect that destruction of ThreadLocal obj is next.");
        num_TestDestructorCalls++;
    }
};

extern "C" void nnMain()
{
    long num_dtrs_to_call;

    NTD_TEST_START();
    NTD_TEST_GROUP_START(TEST_NAME, 1);
    // Spawn the worker thread T1 that enters __nnmusl_call_tls_dtors
    // to destroy "y" when it completes
    TESTLOG("Spawn the worker thread T1 that enters __nnmusl_call_tls_dtors to destroy \"y\" when it completes.");
    std::thread([](){ thread_local Test test; }).join();
    TESTLOG("Spawning T1 completed.");

    TESTLOG("num_ThreadLocalDestructorCalls = %d", num_ThreadLocalDestructorCalls);
    TESTCASE_MESSAGE(num_ThreadLocalDestructorCalls == 1, "Before exiting nnMain we expected 1 calls to ~TlsData1() but we got %ld.",
        num_ThreadLocalDestructorCalls);
    TESTLOG("num_TestDestructorCalls = %d", num_TestDestructorCalls);
    TESTCASE_MESSAGE(num_TestDestructorCalls == 1, "Before exiting nnMain we expected 1 calls to ~TlsData2() but we got %ld.",
        num_TestDestructorCalls);

    num_dtrs_to_call = __nnmusl_get_tls_dtors_status (__dso_handle);
    TESTLOG("There are %ld registered destructors at the end of nnMain.", num_dtrs_to_call);
    TESTCASE_MESSAGE(num_dtrs_to_call == 0, "Before exiting nnMain we expected 0 uncalled Destructors but we got %ld.", num_dtrs_to_call);
    NTD_TEST_GROUP_END(TEST_NAME, 1);
    NTD_TEST_END();
}




