﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>
#include <cstdint>
#include <cstddef>
#include <cstdlib>
#include <pthread.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/os.h>
#include <nn/svc/svc_ThreadLocalRegion.h>
#include <climits>
#include <nn/os/os_ThreadApi.h>
#include "ntd-test-tls.h"

#define MIN_ALIGN nn::os::ThreadStackAlignment

extern void *__dso_handle;  // this is defined in Chris/Sources/Libraries/rocrt/rocrt.cpp

#define STACK_SIZE (3 * MIN_ALIGN)
#define NUM_THREADS 75
#define NUM_HOGE_CONSTRUCTORS 100

const size_t            ThreadStackSize = STACK_SIZE;                 // スレッド操作スレッドのスタックサイズ

typedef struct thread_stack {
    NN_OS_ALIGNAS_THREAD_STACK char  stack[ ThreadStackSize ];   // 1つ目のスレッドのスタック
} thread_stack;
thread_stack            g_ThreadStack[NUM_THREADS];

nn::os::ThreadType      g_Thread[NUM_THREADS];


#define TEST_ROOT_NAME STRINGIZE_VALUE_OF(TLS_TEST_NAME)
#if ULONG_MAX == 0xffffffff
#define TEST_NAME "ARM32-" TEST_ROOT_NAME
#else
#define TEST_NAME "AARCH64-" TEST_ROOT_NAME
#endif

static int counter = 0;
static int num_HogeDestructorCalls = 0;
class Hoge
{
public:
    int x;
    int id;
    nn::os::ThreadType *Hoge_thread;
    char *name = (char *)"<unitialized name>";
    Hoge() {
        id = ++counter;
        Hoge_thread = nn::os::GetCurrentThread();
        TESTLOG("Hello from class Hoge (%s) %d thread address 0x%08zX; id = %d", name, x, (size_t)Hoge_thread, id);
    }
    Hoge(char *func_name, int T) {
        x = T;
        id = ++counter;
        name = func_name;
        Hoge_thread = nn::os::GetCurrentThread();
        TESTLOG("Hello from class Hoge (%s) %d thread address 0x%08zX; id = %d", name, x, (size_t)Hoge_thread, id);
    }
    ~Hoge() {
        TESTLOG("Good-bye from class Hoge (%s) %d thread address 0x%08zX; id = %d!", name, x, (size_t)Hoge_thread, id);
        num_HogeDestructorCalls++;
    }
};
thread_local Hoge g_Hoge00((char *)"g_Hoge00", 0);
thread_local Hoge g_Hoge01((char *)"g_Hoge01", 1);
thread_local Hoge g_Hoge02((char *)"g_Hoge02", 2);
thread_local Hoge g_Hoge03((char *)"g_Hoge03", 3);
thread_local Hoge g_Hoge04((char *)"g_Hoge04", 4);
thread_local Hoge g_Hoge05((char *)"g_Hoge05", 5);
thread_local Hoge g_Hoge06((char *)"g_Hoge06", 6);
thread_local Hoge g_Hoge07((char *)"g_Hoge07", 7);
thread_local Hoge g_Hoge08((char *)"g_Hoge08", 8);
thread_local Hoge g_Hoge09((char *)"g_Hoge09", 9);

thread_local Hoge g_Hoge10((char *)"g_Hoge10", 10);
thread_local Hoge g_Hoge11((char *)"g_Hoge11", 11);
thread_local Hoge g_Hoge12((char *)"g_Hoge12", 12);
thread_local Hoge g_Hoge13((char *)"g_Hoge13", 13);
thread_local Hoge g_Hoge14((char *)"g_Hoge14", 14);
thread_local Hoge g_Hoge15((char *)"g_Hoge15", 15);
thread_local Hoge g_Hoge16((char *)"g_Hoge16", 16);
thread_local Hoge g_Hoge17((char *)"g_Hoge17", 17);
thread_local Hoge g_Hoge18((char *)"g_Hoge18", 18);
thread_local Hoge g_Hoge19((char *)"g_Hoge19", 19);

thread_local Hoge g_Hoge20((char *)"g_Hoge20", 20);
thread_local Hoge g_Hoge21((char *)"g_Hoge21", 21);
thread_local Hoge g_Hoge22((char *)"g_Hoge22", 22);
thread_local Hoge g_Hoge23((char *)"g_Hoge23", 23);
thread_local Hoge g_Hoge24((char *)"g_Hoge24", 24);
thread_local Hoge g_Hoge25((char *)"g_Hoge25", 25);
thread_local Hoge g_Hoge26((char *)"g_Hoge26", 26);
thread_local Hoge g_Hoge27((char *)"g_Hoge27", 27);
thread_local Hoge g_Hoge28((char *)"g_Hoge28", 28);
thread_local Hoge g_Hoge29((char *)"g_Hoge29", 29);

thread_local Hoge g_Hoge30((char *)"g_Hoge30", 30);
thread_local Hoge g_Hoge31((char *)"g_Hoge31", 31);
thread_local Hoge g_Hoge32((char *)"g_Hoge32", 32);
thread_local Hoge g_Hoge33((char *)"g_Hoge33", 33);
thread_local Hoge g_Hoge34((char *)"g_Hoge34", 34);
thread_local Hoge g_Hoge35((char *)"g_Hoge35", 35);
thread_local Hoge g_Hoge36((char *)"g_Hoge36", 36);
thread_local Hoge g_Hoge37((char *)"g_Hoge37", 37);
thread_local Hoge g_Hoge38((char *)"g_Hoge38", 38);
thread_local Hoge g_Hoge39((char *)"g_Hoge39", 39);

thread_local Hoge g_Hoge40((char *)"g_Hoge40", 40);
thread_local Hoge g_Hoge41((char *)"g_Hoge41", 41);
thread_local Hoge g_Hoge42((char *)"g_Hoge42", 42);
thread_local Hoge g_Hoge43((char *)"g_Hoge43", 43);
thread_local Hoge g_Hoge44((char *)"g_Hoge44", 44);
thread_local Hoge g_Hoge45((char *)"g_Hoge45", 45);
thread_local Hoge g_Hoge46((char *)"g_Hoge46", 46);
thread_local Hoge g_Hoge47((char *)"g_Hoge47", 47);
thread_local Hoge g_Hoge48((char *)"g_Hoge48", 48);
thread_local Hoge g_Hoge49((char *)"g_Hoge49", 49);

thread_local Hoge g_Hoge50((char *)"g_Hoge50", 50);
thread_local Hoge g_Hoge51((char *)"g_Hoge51", 51);
thread_local Hoge g_Hoge52((char *)"g_Hoge52", 52);
thread_local Hoge g_Hoge53((char *)"g_Hoge53", 53);
thread_local Hoge g_Hoge54((char *)"g_Hoge54", 54);
thread_local Hoge g_Hoge55((char *)"g_Hoge55", 55);
thread_local Hoge g_Hoge56((char *)"g_Hoge56", 56);
thread_local Hoge g_Hoge57((char *)"g_Hoge57", 57);
thread_local Hoge g_Hoge58((char *)"g_Hoge58", 58);
thread_local Hoge g_Hoge59((char *)"g_Hoge59", 59);

thread_local Hoge g_Hoge60((char *)"g_Hoge60", 60);
thread_local Hoge g_Hoge61((char *)"g_Hoge61", 61);
thread_local Hoge g_Hoge62((char *)"g_Hoge62", 62);
thread_local Hoge g_Hoge63((char *)"g_Hoge63", 63);
thread_local Hoge g_Hoge64((char *)"g_Hoge64", 64);
thread_local Hoge g_Hoge65((char *)"g_Hoge65", 65);
thread_local Hoge g_Hoge66((char *)"g_Hoge66", 66);
thread_local Hoge g_Hoge67((char *)"g_Hoge67", 67);
thread_local Hoge g_Hoge68((char *)"g_Hoge68", 68);
thread_local Hoge g_Hoge69((char *)"g_Hoge69", 69);

thread_local Hoge g_Hoge70((char *)"g_Hoge70", 70);
thread_local Hoge g_Hoge71((char *)"g_Hoge71", 71);
thread_local Hoge g_Hoge72((char *)"g_Hoge72", 72);
thread_local Hoge g_Hoge73((char *)"g_Hoge73", 73);
thread_local Hoge g_Hoge74((char *)"g_Hoge74", 74);
thread_local Hoge g_Hoge75((char *)"g_Hoge75", 75);
thread_local Hoge g_Hoge76((char *)"g_Hoge76", 76);
thread_local Hoge g_Hoge77((char *)"g_Hoge77", 77);
thread_local Hoge g_Hoge78((char *)"g_Hoge78", 78);
thread_local Hoge g_Hoge79((char *)"g_Hoge79", 79);

thread_local Hoge g_Hoge80((char *)"g_Hoge80", 80);
thread_local Hoge g_Hoge81((char *)"g_Hoge81", 81);
thread_local Hoge g_Hoge82((char *)"g_Hoge82", 82);
thread_local Hoge g_Hoge83((char *)"g_Hoge83", 83);
thread_local Hoge g_Hoge84((char *)"g_Hoge84", 84);
thread_local Hoge g_Hoge85((char *)"g_Hoge85", 85);
thread_local Hoge g_Hoge86((char *)"g_Hoge86", 86);
thread_local Hoge g_Hoge87((char *)"g_Hoge87", 87);
thread_local Hoge g_Hoge88((char *)"g_Hoge88", 88);
thread_local Hoge g_Hoge89((char *)"g_Hoge89", 89);

thread_local Hoge g_Hoge90((char *)"g_Hoge90", 90);
thread_local Hoge g_Hoge91((char *)"g_Hoge91", 91);
thread_local Hoge g_Hoge92((char *)"g_Hoge92", 92);
thread_local Hoge g_Hoge93((char *)"g_Hoge93", 93);
thread_local Hoge g_Hoge94((char *)"g_Hoge94", 94);
thread_local Hoge g_Hoge95((char *)"g_Hoge95", 95);
thread_local Hoge g_Hoge96((char *)"g_Hoge96", 96);
thread_local Hoge g_Hoge97((char *)"g_Hoge97", 97);
thread_local Hoge g_Hoge98((char *)"g_Hoge98", 98);
thread_local Hoge g_Hoge99((char *)"g_Hoge99", 99);

thread_local int trigger;

/*---------------------------------------------------------------------------*
  Name:         TestThread

  Description:  This is the main function of the thread.
                It displays the resulting values of each variable.

  Arguments:    1 or 2.

  Returns:      Always zero

 *---------------------------------------------------------------------------*/

static void TestThread(void *arg)
{
    long num_dtrs_to_call_start, num_dtrs_to_call_end;
    num_dtrs_to_call_start = __nnmusl_get_tls_dtors_status (__dso_handle);
    TESTLOG("There are %ld registered destructors at the beginning of TestThread %p.", num_dtrs_to_call_start, arg);

    TESTCASE_MESSAGE(trigger == 0, "trigger when initialized: %d (expected 0)", trigger);

    num_dtrs_to_call_end = __nnmusl_get_tls_dtors_status (__dso_handle);
    TESTLOG("There are %ld registered destructors at the end of TestThread %p.", num_dtrs_to_call_end, arg);
}

/*---------------------------------------------------------------------------*
  Name:         main

  Description:  This is the main function of the demo.

                This demo displays Hello! on the main thread and sub-threads.

  Arguments:    None.

  Returns:      Always zero.

 *---------------------------------------------------------------------------*/
extern "C" void nnMain()
{
    size_t i;

    NTD_TEST_START();
    NTD_TEST_GROUP_START(TEST_NAME, 1);

    TESTLOG("This TLS Constructor test stress tests that a constructor will be called in the first function that has any thread_local variable referenced in it.");
    TESTLOG("The stress test defines 100 threads and each one will have 100 constructors and destructors.");
    TESTLOG("The thread_local variable has to be visible in the compilation unit but it doesn't have to be the class object.  Any variable will do.");

    nn::Result      result;
    long            num_dtrs_to_call = 0;
    nn::os::ThreadType *main_thread = nn::os::GetCurrentThread();
    TESTLOG("1: main_thread = 0x%08zX", (size_t)main_thread);
    TESTLOG("begin creating threads");
    for (i = 0; i < NUM_THREADS; i++) {
        result = nn::os::CreateThread( &(g_Thread[i]), TestThread, (void *)i, g_ThreadStack[i].stack, ThreadStackSize, nn::os::DefaultThreadPriority );
        NN_ASSERT( result.IsSuccess(), "Cannot create g_Thread[%zd].", i );
        TESTLOG("g_Thread[%zd] = 0x%08zX created", i, (size_t)&(g_Thread[i]));
    }

    main_thread = nn::os::GetCurrentThread();
    TESTLOG("2: main_thread = 0x%08zX", (size_t)main_thread);

    TESTLOG("1: Just before calling __nnmusl_get_tls_dtors_status");
    num_dtrs_to_call = __nnmusl_get_tls_dtors_status (__dso_handle);
    TESTCASE_MESSAGE(num_dtrs_to_call == 0, "Before calling nn::os::StartThread we expected 0 uncalled Destructor but we got %ld.", num_dtrs_to_call);

    TESTLOG("begin starting threads");
    num_dtrs_to_call = __nnmusl_get_tls_dtors_status (__dso_handle);
    TESTLOG("There are %ld registered destructors before starting threads.", num_dtrs_to_call);
    // スレッドの実行を開始する
    for (i = 0; i < NUM_THREADS; i++) {
        nn::os::StartThread( &(g_Thread[i]) );
        TESTLOG("g_Thread[%zd] = 0x%08zX started", i, (size_t)&(g_Thread[i]));
    }

    TESTLOG("begin waiting threads");
    num_dtrs_to_call = __nnmusl_get_tls_dtors_status (__dso_handle);
    TESTLOG("There are %ld registered destructors before waiting threads.", num_dtrs_to_call);
    // スレッドが終了するのを待つ
    for (i = 0; i < NUM_THREADS; i++) {
        nn::os::WaitThread( &(g_Thread[i]) );
        TESTLOG("g_Thread[%zd] = 0x%08zX did wait", i, (size_t)&(g_Thread[i]));
    }

    TESTLOG("begin destroying threads");
    num_dtrs_to_call = __nnmusl_get_tls_dtors_status (__dso_handle);
    TESTLOG("There are %ld registered destructors before destroying threads.", num_dtrs_to_call);
    // スレッドを破棄する
    for (i = 0; i < NUM_THREADS; i++) {
        nn::os::DestroyThread( &(g_Thread[i]) );
        TESTLOG("g_Thread[%zd] = 0x%08zX destroyed", i, (size_t)&(g_Thread[i]));
    }

    TESTLOG("done destroying threads");
    TESTLOG("num_HogeDestructorCalls = %d", num_HogeDestructorCalls);
    TESTCASE_MESSAGE(num_HogeDestructorCalls == (NUM_THREADS * NUM_HOGE_CONSTRUCTORS), "Before exiting nnMain we expected %d calls to ~Hoge() but we got %ld.",
        (NUM_THREADS * NUM_HOGE_CONSTRUCTORS), num_HogeDestructorCalls);

    num_dtrs_to_call = __nnmusl_get_tls_dtors_status (__dso_handle);
    TESTLOG("There are %ld registered destructors at the end of nnMain.", num_dtrs_to_call);
    TESTCASE_MESSAGE(num_dtrs_to_call == 0, "Before exiting nnMain we expected 0 uncalled Destructors but we got %ld.", num_dtrs_to_call);

    NTD_TEST_GROUP_END(TEST_NAME, 1);
    NTD_TEST_END();
}

