﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <new>
#include <cstdlib>
#include <cstring>
#include <cerrno>

#include <nn/nn_Macro.h>
#include <nn/nn_Abort.h>
#include <nn/init/init_Malloc.h>
#include <nn/os.h>
#include <nn/mem.h>
#include <nn/os/os_MemoryAllocatorForThreadLocal.h>
#include <nn/os/os_SdkMemoryAllocatorForThreadLocal.h>
#include <nn/nn_Log.h>
#include <nn/init.h>
#include "ntd-test-tls.h"

#if defined(NN_BUILD_CONFIG_OS_HORIZON)
namespace {

    const size_t                TlsBufferSize = 128 * 1024 * 1024;
    NN_ALIGNAS(4096) uint8_t    g_TlsBuffer[ TlsBufferSize ];
    nn::util::TypedStorage<nn::mem::StandardAllocator,sizeof(nn::mem::StandardAllocator),NN_ALIGNOF(nn::mem::StandardAllocator)>    g_TlsAllocator;

    void* CustomAllocatorForThreadLocal(size_t size, size_t alignment) NN_NOEXCEPT
    {
        return Get(g_TlsAllocator).Allocate(size, alignment);
    }

    void CustomDeallocatorForThreadLocal(void* p, size_t size) NN_NOEXCEPT
    {
        NN_UNUSED(size);
        if (p)
        {
            Get(g_TlsAllocator).Free(p);
        }
    }
}
#endif  // NN_BUILD_CONFIG_OS_HORIZON

//---------------------------------------------------------------------------
//  デフォルトの nninitStartup() が適用されないように空関数として定義。
extern "C" void nninitStartup()
{
    static uint8_t TlsBuffer[4 * 1024 * 1024];
    nn::init::InitializeAllocator(TlsBuffer, sizeof(TlsBuffer));

    TESTLOG("Using default malloc allocators");

#if defined(NN_BUILD_CONFIG_OS_HORIZON)
    new( &Get(g_TlsAllocator) ) nn::mem::StandardAllocator;
    Get(g_TlsAllocator).Initialize(g_TlsBuffer, TlsBufferSize);

    // コンパイラのスレッドローカル実装用のメモリアロケータの登録
    nn::os::SetMemoryAllocatorForThreadLocal(
                            CustomAllocatorForThreadLocal,
                            CustomDeallocatorForThreadLocal);

    TESTLOG("TLS allocators customized in %s line %d", __FILE__, __LINE__);
#endif  // NN_BUILD_CONFIG_OS_HORIZON
}

