﻿#include "pdclib-tests/pdclib-tests.h"


void pdclib_function_tests(void)
{
    NTD_TEST_GROUP_START("functions", 1);
    // PDCLIB does not apply local tests unique to PDCLIB functions__PDCLIB();
    functions_ctype();
    functions_inttypes();
    // No actual tests in PDCLIB for locale functions_locale();
    functions_stdio();
    functions_stdlib();
    functions_string();
    // No actual tests in PDCLIB for uchar functions_uchar();
    functions_wchar();
    functions_wctype();
    NTD_TEST_GROUP_END("functions", 1);
}

void pdclib_opt_tests(void)
{
    NTD_TEST_GROUP_START("opt", 1);
    // No actual tests in basecodecs opt_basecodecs();
    // No actual tests in opt_c_locale();
    // No actual tests in dlmalloc opt_dlmalloc();
    opt_malloc_solar();
    // No actual tests in mincoll opt_mincoll();
    /* opt_nothread(); don't run opt_nothread it is only if threads are not supported and is  NOP */
    // No actual tests in notime opt_notime();
    opt_pthreads();
    opt_tss_errno();
    NTD_TEST_GROUP_END("opt", 1);
}

#if PDCLIB_TEST_PLATFORMS
void pdclib_platform_example_tests(void)
{
    NTD_TEST_GROUP_START("example", 2);
    platform_example_functions__PDCLIB();
    platform_example_functions_signal();
    platform_example_functions_stdio();
    platform_example_functions_stdlib();
    NTD_TEST_GROUP_END("example", 2);
}

void pdclib_platform_gandr_tests(void)
{
    NTD_TEST_GROUP_START("gandr", 2);
    platform_gandr_functions__PDCLIB();
    platform_gandr_functions_signal();
    platform_gandr_functions_stdio();
    NTD_TEST_GROUP_END("gandr", 2);
}

void pdclib_platform_posix_tests(void)
{
    NTD_TEST_GROUP_START("posix", 2);
    platform_posix_functions__PDCLIB();
    platform_posix_functions_signal();
    platform_posix_functions_stdio();
    platform_posix_functions_stdlib();
    NTD_TEST_GROUP_END("posix", 2);
}

void pdclib_platform_win32_tests(void)
{
    NTD_TEST_GROUP_START("win32", 2);
    platform_win32_functions__PDCLIB();
    platform_win32_functions_signal();
    platform_win32_functions_stdio();
    platform_win32_functions_stdlib();
    platform_win32_functions_threads();
    NTD_TEST_GROUP_END("win32", 2);
}

void pdclib_platform_tests(void)
{
    NTD_TEST_GROUP_START("platform", 1);
    pdclib_platform_gandr_tests();
    pdclib_platform_posix_tests();
    pdclib_platform_win32_tests();
    NTD_TEST_GROUP_END("platfrom", 1);
}
#endif

void pdclib_tests(void)
{
    NTD_TEST_GROUP_START("PDCLIB TESTS", 0);
    pdclib_function_tests();
    pdclib_opt_tests();
#if PDCLIB_TEST_PLATFORMS
    pdclib_platform_tests();
#endif
    NTD_TEST_GROUP_END("PDCLIB TESTS", 0);
}
