﻿/* towctrans( wint_t, wctrans_t )

   This file is part of the Public Dotest_towctrans C Library (PDCLib).
   Permission is granted to use, modify, and / or redistribute at will.
*/

#include <wctype.h>

#include "pdclib-tests/pdclib-tests.h"

int test_towctrans( void )
{
    TESTCASE(towctrans(L'a', wctrans("toupper")) == L'A');
    TESTCASE(towctrans(L'B', wctrans("toupper")) == L'B');
    TESTCASE(towctrans(L'a', wctrans("tolower")) == L'a');
    TESTCASE(towctrans(L'B', wctrans("tolower")) == L'b');
    TESTCASE(towctrans(L'B', wctrans("invalid")) == L'B');
    TESTCASE(towctrans(L'B', 0)                  == L'B');
    return TEST_RESULTS;
}
