﻿/* wmemcpy( wchar_t *, const wchar_t *, size_t )

   This file is part of the Public Dotest_wmemcpy C Library (PDCLib).
   Permission is granted to use, modify, and / or redistribute at will.
*/

#include <wchar.h>


#include "pdclib-tests/pdclib-tests.h"

int test_wmemcpy( void )
{
    wchar_t s[] = L"xxxxxxxxxxx";
    TESTCASE( wmemcpy( s, wabcde, 6 ) == s );
    TESTCASE( s[4] == L'e' );
    TESTCASE( s[5] == L'\0' );
    TESTCASE( wmemcpy( s + 5, wabcde, 5 ) == s + 5 );
    TESTCASE( s[9] == L'e' );
    TESTCASE( s[10] == L'x' );
    return TEST_RESULTS;
}
