﻿/* wcscat( wchar_t *, const wchar_t * )

   This file is part of the Public Dotest_wcscat C Library (PDCLib).
   Permission is granted to use, modify, and / or redistribute at will.
*/

#include <wchar.h>


#include "pdclib-tests/pdclib-tests.h"

int test_wcscat( void )
{
    wchar_t s[] = L"xx\0xxxxxx";
    TESTCASE( wcscat( s, wabcde ) == s );
    TESTCASE( s[2] == L'a' );
    TESTCASE( s[6] == L'e' );
    TESTCASE( s[7] == L'\0' );
    TESTCASE( s[8] == L'x' );
    s[0] = L'\0';
    TESTCASE( wcscat( s, wabcdx ) == s );
    TESTCASE( s[4] == L'x' );
    TESTCASE( s[5] == L'\0' );
    TESTCASE( wcscat( s, L"\0" ) == s );
    TESTCASE( s[5] == L'\0' );
    TESTCASE( s[6] == L'e' );
    return TEST_RESULTS;
}
