﻿/* [XSI] char* strdup(const char *)

   This file is part of the Public Dotest_strdup C Library (PDCLib).
   Permission is granted to use, modify, and / or redistribute at will.
*/

#define _BSD_SOURCE
#include <string.h>
#include <stdlib.h>


#include "pdclib-tests/pdclib-tests.h"

int test_strdup( void )
{
    const char *teststr  = "Hello, world";
    const char *teststr2 = "An alternative test string with non-7-bit characters \xFE\x8C\n";
    char *testres, *testres2;

    TESTCASE(testres  = strdup(teststr));
    TESTCASE(testres2 = strdup(teststr2));
    TESTCASE(strcmp(testres, teststr) == 0);
    TESTCASE(strcmp(testres2, teststr2) == 0);
    free(testres);
    free(testres2);

    return TEST_RESULTS;
}

