﻿/* $Id$ */

/* fputs( const char *, FILE * )

   This file is part of the Public Dotest_fputs C Library (PDCLib).
   Permission is granted to use, modify, and / or redistribute at will.
*/

#include <stdio.h>

#include "pdclib-tests/pdclib-tests.h"

int test_fputs( void )
{
    char const * const message = "SUCCESS testing fputs()";
    FILE * fh;
    TESTCASE( ( fh = tmpfile() ) != NULL );
    TESTCASE( fputs( message, fh ) >= 0 );
    rewind( fh );
    for ( size_t i = 0; i < 23; ++i )
    {
        TESTCASE( fgetc( fh ) == message[i] );
    }
    TESTCASE( fclose( fh ) == 0 );
    return TEST_RESULTS;
}


