﻿/* _cbprintf( void *, size_t (*)( void*, const char *, size_t ), const char *, ... )

   This file is part of the Public Dotest__cbprintf C Library (PDCLib).
   Permission is granted to use, modify, and / or redistribute at will.
*/

#include <stdio.h>
#include <stdint.h>
#include <stdarg.h>


#define _PDCLIB_FILEID "stdio/sprintf.c"
#define _PDCLIB_STRINGIO
#include <stddef.h>

#include "pdclib-tests/pdclib-tests.h"

static char * bufptr;
static size_t testcb( void *p, const char *buf, size_t size )
{
    memcpy(bufptr, buf, size);
    bufptr += size;
    *bufptr = '\0';
    return size;
}

#define testprintf( s, ... ) _cbprintf( bufptr = s, testcb, __VA_ARGS__ )

int test__cbprintf( void )
{
    char target[100];
    return TEST_RESULTS;
}

