﻿/*---------------------------------------------------------------------------*
  Copyright (C)2014 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include <stdlib.h> //malloc
#include <nn/nn_Log.h>
#include <nn/fs_Base.h>
#include <nn/fs/fs_ResultHandler.h>
#include <nn/os/os_Argument.h>
extern "C"
{
#include "ntd_malloc_node.h"
}

extern "C" void testsuite_main(void);

namespace
{
    void* Allocate(size_t size)
    {
        return malloc(size);
    }

    void Deallocate(void* p, size_t size)
    {
        NN_UNUSED(size);
        free(p);
    }
}

#define HOST_MOUNT_PATH "C:/ntd-test-libc"

extern malloc_node * malloc_head;

extern "C" void nnMain()
{
    const char* mount_path = (nn::os::GetHostArgc() > 1) ? nn::os::GetHostArgv()[1] : HOST_MOUNT_PATH;

    nn::fs::SetEnabledAutoAbort(false);
    nn::fs::SetResultHandledByApplication(true);
    nn::fs::SetAllocator(Allocate, Deallocate);
    NN_LOG( "Mounting host file system: %s\n", mount_path );
    nn::Result result = nn::fs::MountHost("host", mount_path);
    if (result.IsSuccess()) {
        NN_LOG( "STARTING RYNDA TEST LIBC\n" );

        malloc_head = NULL;

        testsuite_main();

    } else {
        NN_LOG( "FAILURE: Unable to mount: '%s' please create this directory\n", mount_path );
    }
}
