﻿/*******************************************************************************

  This file contains a series of tests for ftruncate()

*******************************************************************************/

#include "ntd-tests/ntd-tests.h"
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>

#define BUF_SIZE 1024
static char buffer[BUF_SIZE];

static void validate_file_contents(char *file, int line, int fd, char *value, size_t size)
{
    off_t off = lseek(fd, 0, SEEK_SET);
    NTD_TESTCASE_MESSAGE(off != -1, file, line,
        "off != -1",
        "lseek(%d, 0, SEEK_SET) returned %d expected 0", fd, off);
    ssize_t readbytes = read(fd, buffer, sizeof(buffer));
    NTD_TESTCASE_MESSAGE(readbytes == size, file, line,
        "",
        "read(%d, buffer, %d) returned %d expected %d",
        fd,
        (int) sizeof(buffer),
        (int) readbytes,
        (int) size);
    int result = memcmp(value, buffer, size);
    NTD_TESTCASE_MESSAGE(result == 0, file, line,
        "",
        "memcmp('%.*s', '%.*s', %d) returned %d",
        readbytes, buffer, size, value, result);
}
#define VALIDATE_FILE_CONTENTS(fd, value, size) validate_file_contents(__FILE__, __LINE__, fd, value, size)

static void test_ftruncate_simple()
{
    const char *filename = HOST_FILENAME("ftruncate_simple.txt");
    const char *init_data = "0123456789";
    int fd;

    DELETE_IF_EXISTS(filename);
    CREATE_FILE_TEST(filename, init_data);
    fd = open(filename, O_RDWR);
    if (fd < 0) {
        TESTCASE_MESSAGE(fd >= 0, "open(%s, O_RDWR) returned %d\n", filename, fd);
        return;
    }
    VALIDATE_FILE_CONTENTS(fd, init_data, strlen(init_data));
    int result = ftruncate(fd, 2);
    TESTCASE_MESSAGE(result == 0, "ftruncate(%d) returned %d expected 0\n", fd, result);
    VALIDATE_FILE_CONTENTS(fd, init_data, 2);
    result = close(fd);
    TESTCASE_MESSAGE(result == 0, "close(%d) returned %d expected 0\n", fd, result);
    DELETE_IF_EXISTS(filename);
}

void test_ftruncate(void)
{
    NTD_TEST_GROUP_START("ftruncate", 3);
    test_ftruncate_simple();
    NTD_TEST_GROUP_END("ftruncate", 3);
}
