﻿/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include "thread_test.h"
/* The header above includes other headers this file needs:
     #include <stdio.h>
*/
#include <pthread.h>
#include <inttypes.h>
#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */
  #include "ntd-tests/ntd-tests.h"
#ifdef __cplusplus
}
#endif /* __cplusplus */

#define         NUMTHREADS    3
static int             number      = 0;
static uintptr_t       okStatus    = 777;
static pthread_once_t  onceControl = PTHREAD_ONCE_INIT;

static pthread_once_t  flag1 = PTHREAD_ONCE_INIT;
static pthread_once_t  flag2 = PTHREAD_ONCE_INIT;
static pthread_once_t  flag3 = PTHREAD_ONCE_INIT;
static pthread_once_t  flag4 = PTHREAD_ONCE_INIT;
static pthread_once_t  flag5 = PTHREAD_ONCE_INIT;

static void once_func5() {}

static void once_func4() {
    pthread_once(&flag5, once_func5);
}

static void once_func3() {
    pthread_once(&flag4, once_func4);
}

static void once_func2() {
    pthread_once(&flag3, once_func3);
}

static void once_func1() {
    pthread_once(&flag2, once_func2);
}

static bool SafeInitDemo() {
    int e = pthread_once(&flag1, once_func1);
    return true;
}

static void initRoutine(void)
{
    TESTWARN("In the initRoutine setting number to %d\n", number + 1);
    number++;
}

static void *threadfunc(void *parm)
{
    int                   rc=0;

    TESTWARN("Inside secondary thread: onceControl is %p for thread %" PRIdPTR "\n", onceControl, (uintptr_t)(parm));
    rc = pthread_once(&onceControl, initRoutine);
    TESTCASE_MESSAGE(rc == 0, "pthread_join() returned %d expected 0", rc);
    TESTWARN("Inside secondary thread: after call to pthread_once for thread %" PRIdPTR "\n", (uintptr_t)(parm));

    return (void *)(okStatus);
}

void test_pthread_once()
{
    pthread_t             thread[NUMTHREADS];
    int                   rc=0;
    uintptr_t             i=NUMTHREADS;
    void                 *status;
    bool                  test;
    const char *testcase = __FUNCTION__;

    NTD_TEST_GROUP_START("once", 3);

    for (i=0; i < NUMTHREADS; ++i) {
        TESTWARN("Create thread %d\n", i);
        rc = pthread_create(&thread[i], NULL, threadfunc, (void *)(i));
        TESTCASE_MESSAGE(rc == 0, "pthread_create() returned %d expected 0", rc);
    }

    for (i=0; i < NUMTHREADS; ++i) {
        TESTWARN("Wait for thread %d\n", i);
        rc = pthread_join(thread[i], &status);
        TESTCASE_MESSAGE(rc == 0, "pthread_join() returned %d expected 0", rc);
        if ((uintptr_t)(status) != okStatus) {
              TESTWARN("Secondary thread failed: thread %d\n", i);
        }
    }

    test = (number == 1);
    TESTCASE( test );
    if (!test) {
        TESTWARN("An incorrect number (%d) of 1 one-time init routine was called!\n", number);
    } else {
        TESTWARN("One-time init routine called exactly once\n");
    }

    test = SafeInitDemo();

    TESTCASE(test);

    NTD_TEST_GROUP_END("once", 3);
}

#if 0
Debug output:

Enter Testcase - QP0WTEST/TPONCE0
Create thread 0
Create thread 1
Create thread 2
Wait for thread 0
Inside secondary thread
In the initRoutine
Inside secondary thread
Wait for thread 1
Wait for thread 2
Inside secondary thread
One-time init routine called exactly once
Main completed
#endif
