﻿/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include "thread_test.h"
/* The header above includes other headers this file needs:
     #include <stdio.h>
*/
#include <pthread.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */
  #include "ntd-tests/ntd-tests.h"
#ifdef __cplusplus
}
#endif /* __cplusplus */

pthread_mutex_t            mutex;

void test_pthread_mutex_destroy()
{
  int                   rc=0;
  const char *testcase = __FUNCTION__;

  NTD_TEST_GROUP_START("mutex_destroy", 3);

  TESTWARN("Create the mutex using the NULL attributes (default)\n");
  rc = pthread_mutex_init(&mutex, NULL);
  TESTCASE_MESSAGE(rc == 0, "pthread_mutex_init(NULL) returned %d expected 0", rc);

  TESTWARN("Destroy all mutexes\n");

  pthread_mutex_destroy(&mutex);
  TESTCASE_MESSAGE(rc == 0, "pthread_mutex_destroy() returned %d expected 0", rc);

  NTD_TEST_GROUP_END("mutex_destroy", 3);
}

#if 0
Debug output:

Entering testcase
Create the mutex using the NULL attributes (default)
Destroy all mutexes
Main completed
#endif
