﻿/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include "thread_test.h"
/* The header above includes other headers this file needs:
     #include <stdio.h>
*/
#include <pthread.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */
  #include "ntd-tests/ntd-tests.h"
#ifdef __cplusplus
}
#endif /* __cplusplus */

#if SUPPORT_STATIC_INITALIZATION
static pthread_cond_t      cond1 = PTHREAD_COND_INITIALIZER;
#endif
static pthread_cond_t      cond2;
static pthread_cond_t      cond3;

void test_pthread_cond_init()
{
    int                   rc=0;
    pthread_condattr_t    attr = {0}; /* mea initialized */

    NTD_TEST_GROUP_START("cond_init", 3);

    TESTWARN("Create the default cond attributes object\n");
    rc = pthread_condattr_init(&attr);
    TESTCASE_MESSAGE(rc == 0, "pthread_condattr_init() returned %d expected 0", rc);

    TESTWARN("Create the all of the default conditions in different ways\n");
    rc = pthread_cond_init(&cond2, NULL);
    TESTCASE_MESSAGE(rc == 0, "pthread_cond_init() returned %d expected 0", rc);

    rc = pthread_cond_init(&cond3, &attr);
    TESTCASE_MESSAGE(rc == 0, "pthread_cond_init() returned %d expected 0", rc);

    TESTWARN("- At this point, the conditions with default attributes\n");
    TESTWARN("- Can be used from any threads that want to use them\n");

    TESTWARN("Cleanup\n");
    pthread_condattr_destroy(&attr);
#if SUPPORT_STATIC_INITALIZATION
    pthread_cond_destroy(&cond1);
#endif
    pthread_cond_destroy(&cond2);
    pthread_cond_destroy(&cond3);


    NTD_TEST_GROUP_END("cond_init", 3);
}

#if 0
Debug output:

Enter Testcase - QP0WTEST/TPCOI0
Create the default cond attributes object
Create the all of the default conditions in different ways
- At this point, the conditions with default attributes
- Can be used from any threads that want to use them
Cleanup
Main completed
#endif
