﻿/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

/* NTD-TEST-LIBC */

#include "ntd-tests/ntd-tests.h"

void ntd_functions_threads(void)
{
  NTD_TEST_GROUP_START("ntd_test_threads", 2);

  test_pthread_affinity();
  test_pthread_attr_set_and_get();
  test_pthread_attr_setinheritsched();
  test_pthread_attr_setschedparam_1();
  test_pthread_attr_setschedparam_2();
  test_pthread_attr_setschedpolicy();
  test_pthread_attr_setscope();
  /*test_pthread_attr_setstack();*/ /* Test doesn't work in C (only in C++) */
  test_pthread_barrier();
  test_pthread_cond_broadcast();
  test_pthread_cond_destroy();
  test_pthread_cond_init();
  test_pthread_cond_signal();
  test_pthread_cond_timedwait();
  test_pthread_cond_wait();
  test_pthread_condattr_setpshared();
  test_pthread_errno_locale();
  test_pthread_getschedparam();
  test_pthread_getspecific();
  test_pthread_join();
  test_pthread_key_create();
  test_pthread_key_delete();
  test_pthread_mutex_destroy();
  test_pthread_mutex_init();
  test_pthread_mutex_lock();
  test_pthread_mutex_trylock();
  test_pthread_mutex_trylock_yield();
  test_pthread_mutex_unlock();
  test_pthread_mutexattr_settype();
  test_pthread_once();
  test_pthread_rwlock_basic();
  test_pthread_rwlock_trylock();
  test_pthread_setname_np();
  test_pthread_setspecific();
  test_pthread_validate_filelocks();
  test_sched_get_priority_max();
  test_sched_yield();
  test_sem_destroy();
  test_sem_getvalue();
  test_sem_post();
  test_sem_timedwait();
  test_sem_trywait();
  test_sem_wait();

  NTD_TEST_GROUP_END("ntd_test_threads", 2);
}
