﻿/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include <stdlib.h> /* malloc() */
#include <stdio.h> /* printf() */
#include "ntd-tests/ntd-tests.h"
#include "malloc_test_helper_funcs.h"

/*{{{{------------------------------------------------------------------------*/
/* Checks that when a new pointer is freed that it will get added to the
   freelist*/
void test_elements_added_to_freelist()
{
  const int array_size = 100;
  char* array[array_size] = {0};
  int free_index_separately = array_size - 10; // The special chunk to free separately
  int num_freed_chunks1; // Freed chunks before last free()
  int num_freed_chunks2; // Freed chunks after last free()
  int i; // Loop counter

  for (i = 0; i < array_size; ++i)
  {
    array[i] = (char*)malloc( 1000 + (i * 10) );
  }

  // Space the frees far enough apart so that the freed chunks won't get
  // consolidated together until we want them to
  for (i = 0; i < array_size; i += 10)
  {
    if (i != free_index_separately)
      free(array[i]);
  }

  num_freed_chunks1 = num_freelist_chunks();
  free(array[free_index_separately]);
  num_freed_chunks2 = num_freelist_chunks();


  // The number of freed chunks in the freelist should have increased by one
  TESTCASE( num_freed_chunks2 == (num_freed_chunks1 + 1) );

  // Free the rest of the allocations
  for (i = 0; i < array_size; ++i)
  {
    // Don't free chunks we've already freed
    if (i % 10 == 0)
      continue;

    free(array[i]);
  }
}
/*------------------------------------------------------------------------}}}}*/


int test_WalkFreeList( void )
{
  test_elements_added_to_freelist();
}
