﻿/* $Id$ */

/* clearerr( FILE * )

   This file is part of the Public Dotest_clearerr C Library (PDCLib).
   Permission is granted to use, modify, and / or redistribute at will.
*/

#include "ntd-test-libc.h"
#include <stdio.h>

#include "ntd_stdio_tests.h"

#if __NX__
static const char *tempfilename = "host:/ntd-test-clearerr.txt";
#else
static const char *tempfilename = "ntd-test-clearerr.txt";
#endif

int ntd_stdio_clearerr( void )
{
    FILE * fh;
    TESTCASE( ( fh = fopen(tempfilename, "w+")  ) != NULL );
    /* Flags should be clear */
    TESTCASE( ! ferror( fh ) );
    TESTCASE( ! feof( fh ) );
    /* Reading from input stream - just sets eof should not provoke error */
    TESTCASE( fgetc( fh ) == EOF );
    TESTCASE( ! ferror( fh ) );
    TESTCASE( feof( fh ) );
    /* clearerr() should clear flags */
    clearerr( fh );
    TESTCASE( ! ferror( fh ) );
    TESTCASE( ! feof( fh ) );
    /* Reading from empty stream - should provoke EOF */
    rewind( fh );
    TESTCASE( fgetc( fh ) == EOF );
    TESTCASE( ! ferror( fh ) );
    TESTCASE( feof( fh ) );
    /* clearerr() should clear flags */
    clearerr( fh );
    TESTCASE( ! ferror( fh ) );
    TESTCASE( ! feof( fh ) );
    TESTCASE( fclose( fh ) == 0 );
    return TEST_RESULTS;
}


