﻿/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#ifndef NTD_EXTENDED_TEST_H
#define NTD_EXTENDED_TEST_H 1

#include "ntd-test-libc.h"
#include <stdint.h>
#include <unistd.h>

#if 0
#define T_LOC2(l) __FILE__ ":" #l
#define T_LOC1(l) T_LOC2(l)

int t_printf(const char *s, ...);

int t_vmfill(void **, size_t *, int);
int t_memfill(void);

void t_fdfill(void);

void t_randseed(uint64_t s);
uint64_t t_randn(uint64_t n);
uint64_t t_randint(uint64_t a, uint64_t b);
void t_shuffle(uint64_t *p, size_t n);
void t_randrange(uint64_t *p, size_t n);
int t_choose(uint64_t n, size_t k, uint64_t *p);

char *t_pathrel(char *buf, size_t n, char *argv0, char *p);

int t_setrlim(int r, long lim);

// This variable isn't used in this Horizon version of the testsuite, but the
// linux version of musl-libc-test uses it, so it's included here to make the
// testsuite compile
#define t_status t_status_not_used
static int t_status_not_used = 0;
//static int t_status = 0;
//#undef t_status

#define t_error(...) (t_error_replacement_func(__FILE__, __LINE__, __VA_ARGS__))

int t_error_replacement_func(const char* file, int line, ...);

#define tmpfile() NTD_TEST_TMPFILE(__func__)
#endif

#endif /* NTD_EXTENDED_TEST_H */
