﻿// Copyright (C) 1988-1994 Sun Microsystems, Inc. 2550 Garcia Avenue
// Mountain View, California  94043 All rights reserved.
//
// Any person is hereby authorized to download, copy, use, create bug fixes,
// and distribute, subject to the following conditions:
//
// 	1.  the software may not be redistributed for a fee except as
// 	    reasonable to cover media costs;
// 	2.  any copy of the software must include this notice, as well as
// 	    any other embedded copyright notices; and
// 	3.  any distribution of this software or derivative works thereof
// 	    must comply with all applicable U.S. export control laws.
//
// THE SOFTWARE IS MADE AVAILABLE "AS IS" AND WITHOUT EXPRESS OR IMPLIED
// WARRANTY OF ANY KIND, INCLUDING BUT NOT LIMITED TO THE IMPLIED
// WARRANTIES OF DESIGN, MERCHANTIBILITY, FITNESS FOR A PARTICULAR
// PURPOSE, NON-INFRINGEMENT, PERFORMANCE OR CONFORMANCE TO
// SPECIFICATIONS.
//
// BY DOWNLOADING AND/OR USING THIS SOFTWARE, THE USER WAIVES ALL CLAIMS
// AGAINST SUN MICROSYSTEMS, INC. AND ITS AFFILIATED COMPANIES IN ANY
// JURISDICTION, INCLUDING BUT NOT LIMITED TO CLAIMS FOR DAMAGES OR
// EQUITABLE RELIEF BASED ON LOSS OF DATA, AND SPECIFICALLY WAIVES EVEN
// UNKNOWN OR UNANTICIPATED CLAIMS OR LOSSES, PRESENT AND FUTURE.
//
// IN NO EVENT WILL SUN MICROSYSTEMS, INC. OR ANY OF ITS AFFILIATED
// COMPANIES BE LIABLE FOR ANY LOST REVENUE OR PROFITS OR OTHER SPECIAL,
// INDIRECT AND CONSEQUENTIAL DAMAGES, EVEN IF IT HAS BEEN ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGES.
//
// This file is provided with no support and without any obligation on the
// part of Sun Microsystems, Inc. ("Sun") or any of its affiliated
// companies to assist in its use, correction, modification or
// enhancement.  Nevertheless, and without creating any obligation on its
// part, Sun welcomes your comments concerning the software and requests
// that they be sent to fdlibm-comments@sunpro.sun.com.
// sqrt(+-0) is +-0
T(RN,          0x0p+0,          0x0p+0,          0x0p+0, 0)
T(RN,         -0x0p+0,         -0x0p+0,          0x0p+0, 0)
T(RZ,          0x0p+0,          0x0p+0,          0x0p+0, 0)
T(RZ,         -0x0p+0,         -0x0p+0,          0x0p+0, 0)
T(RU,          0x0p+0,          0x0p+0,          0x0p+0, 0)
T(RU,         -0x0p+0,         -0x0p+0,          0x0p+0, 0)
T(RD,          0x0p+0,          0x0p+0,          0x0p+0, 0)
T(RD,         -0x0p+0,         -0x0p+0,          0x0p+0, 0)
// sqrt(+max) is finite
T(RN, 0x1.fffffep+127,  0x1.fffffep+63,         -0x1p-1, INEXACT)
T(RZ, 0x1.fffffep+127,  0x1.fffffep+63,         -0x1p-1, INEXACT)
T(RU, 0x1.fffffep+127,         0x1p+64,          0x1p-2, INEXACT)
T(RD, 0x1.fffffep+127,  0x1.fffffep+63,         -0x1p-1, INEXACT)
// sqrt(16736281) = 4091
T(RN,  0x1.fec032p+23,     0x1.ff6p+11,          0x0p+0, 0)
T(RZ,  0x1.fec032p+23,     0x1.ff6p+11,          0x0p+0, 0)
T(RU,  0x1.fec032p+23,     0x1.ff6p+11,          0x0p+0, 0)
T(RD,  0x1.fec032p+23,     0x1.ff6p+11,          0x0p+0, 0)
// sqrt(16088121) = 4011
T(RN,  0x1.eaf872p+23,     0x1.f56p+11,          0x0p+0, 0)
T(RZ,  0x1.eaf872p+23,     0x1.f56p+11,          0x0p+0, 0)
T(RU,  0x1.eaf872p+23,     0x1.f56p+11,          0x0p+0, 0)
T(RD,  0x1.eaf872p+23,     0x1.f56p+11,          0x0p+0, 0)
// sqrt(4)=2
T(RN,          0x1p+2,          0x1p+1,          0x0p+0, 0)
T(RZ,          0x1p+2,          0x1p+1,          0x0p+0, 0)
T(RU,          0x1p+2,          0x1p+1,          0x0p+0, 0)
T(RD,          0x1p+2,          0x1p+1,          0x0p+0, 0)
// sqrt(x) for x=1,1+ulp,1-ulp
T(RN,   0x1.000002p+0,          0x1p+0,         -0x1p-1, INEXACT)
T(RN,          0x1p+0,          0x1p+0,          0x0p+0, 0)
T(RN,   0x1.fffffep-1,   0x1.fffffep-1,         -0x1p-1, INEXACT)
T(RZ,   0x1.000002p+0,          0x1p+0,         -0x1p-1, INEXACT)
T(RZ,          0x1p+0,          0x1p+0,          0x0p+0, 0)
T(RZ,   0x1.fffffep-1,   0x1.fffffep-1,         -0x1p-1, INEXACT)
T(RU,   0x1.000002p+0,   0x1.000002p+0,          0x1p-1, INEXACT)
T(RU,          0x1p+0,          0x1p+0,          0x0p+0, 0)
T(RU,   0x1.fffffep-1,          0x1p+0,          0x1p-2, INEXACT)
T(RD,   0x1.000002p+0,          0x1p+0,         -0x1p-1, INEXACT)
T(RD,          0x1p+0,          0x1p+0,          0x0p+0, 0)
T(RD,   0x1.fffffep-1,   0x1.fffffep-1,         -0x1p-1, INEXACT)
// sqrt(+min) is non-zero
T(RN,        0x1p-126,         0x1p-63,          0x0p+0, 0)
T(RZ,        0x1p-126,         0x1p-63,          0x0p+0, 0)
T(RU,        0x1p-126,         0x1p-63,          0x0p+0, 0)
T(RD,        0x1p-126,         0x1p-63,          0x0p+0, 0)
// random arguments between 0 8
T(RN,   0x1.766bdcp+1,     0x1.b5d7p+0,   0x1.8023f6p-2, INEXACT)
T(RN,    0x1.b6547p+2,   0x1.4efb34p+1,   0x1.ab352ap-2, INEXACT)
T(RN,    0x1.e1653p+2,   0x1.5f0d32p+1,  -0x1.3a5a34p-5, INEXACT)
T(RN,    0x1.541ddp+0,   0x1.271372p+0,   0x1.eb2696p-2, INEXACT)
T(RN,   0x1.754c3ep+1,   0x1.b52eb4p+0,  -0x1.1c5f7cp-3, INEXACT)
T(RN,   0x1.ebe1e2p+1,   0x1.f5d724p+0,   0x1.e45af6p-2, INEXACT)
T(RN,   0x1.940d8ep+2,   0x1.419dfap+1,   0x1.667d7ap-4, INEXACT)
T(RN,   0x1.dae714p+2,   0x1.5cad1ap+1,  -0x1.8e8572p-5, INEXACT)
T(RN,   0x1.a9f2d2p+1,   0x1.d2ff14p+0,  -0x1.20826cp-3, INEXACT)
T(RN,   0x1.57dd34p-3,   0x1.a397d8p-2,  -0x1.10b108p-3, INEXACT)
// sqrt(min subnormal) is non-zero
T(RN,        0x1p-149,  0x1.6a09e6p-75,  -0x1.9fcef4p-3, INEXACT)
T(RZ,        0x1p-149,  0x1.6a09e6p-75,  -0x1.9fcef4p-3, INEXACT)
T(RU,        0x1p-149,  0x1.6a09e8p-75,   0x1.980c44p-1, INEXACT)
T(RD,        0x1p-149,  0x1.6a09e6p-75,  -0x1.9fcef4p-3, INEXACT)
// sqrt(inf) is inf
T(RN,             inf,             inf,          0x0p+0, 0)
T(RZ,             inf,             inf,          0x0p+0, 0)
T(RU,             inf,             inf,          0x0p+0, 0)
T(RD,             inf,             inf,          0x0p+0, 0)
// sqrt(nan) is nan
ARM_EXPECT_FAIL("RYNDA-246", RN,             nan,             nan,          0x0p+0, 0)
ARM_EXPECT_FAIL("RYNDA-246", RZ,             nan,             nan,          0x0p+0, 0)
ARM_EXPECT_FAIL("RYNDA-246", RU,             nan,             nan,          0x0p+0, 0)
ARM_EXPECT_FAIL("RYNDA-246", RD,             nan,             nan,          0x0p+0, 0)
// sqrt(-ve) is nan
T(RN,       -0x1p-149,             nan,          0x0p+0, INVALID)
T(RN,         -0x1p+0,             nan,          0x0p+0, INVALID)
T(RN,            -inf,             nan,          0x0p+0, INVALID)
T(RZ,       -0x1p-149,             nan,          0x0p+0, INVALID)
T(RZ,         -0x1p+0,             nan,          0x0p+0, INVALID)
T(RZ,            -inf,             nan,          0x0p+0, INVALID)
T(RU,       -0x1p-149,             nan,          0x0p+0, INVALID)
T(RU,         -0x1p+0,             nan,          0x0p+0, INVALID)
T(RU,            -inf,             nan,          0x0p+0, INVALID)
T(RD,       -0x1p-149,             nan,          0x0p+0, INVALID)
T(RD,         -0x1p+0,             nan,          0x0p+0, INVALID)
T(RD,            -inf,             nan,          0x0p+0, INVALID)
T(RD,        0x1p-148,         0x1p-74,          0x0p+0, 0)
T(RD,        0x1p-146,         0x1p-73,          0x0p+0, 0)
T(RD,        0x1p-128,         0x1p-64,          0x0p+0, 0)
T(RD,        0x1p-124,         0x1p-62,          0x0p+0, 0)
T(RD,       0x1.2p-15,        0x1.8p-8,          0x0p+0, 0)
T(RD,          0x1p-8,          0x1p-4,          0x0p+0, 0)
T(RD,        0x1.2p-5,        0x1.8p-3,          0x0p+0, 0)
T(RD,          0x1p-4,          0x1p-2,          0x0p+0, 0)
T(RD,        0x1.2p+3,        0x1.8p+1,          0x0p+0, 0)
T(RD,          0x1p+8,          0x1p+4,          0x0p+0, 0)
T(RD,       0x1.2p+11,        0x1.8p+5,          0x0p+0, 0)
T(RD,    0x1.9f24p+14,       0x1.46p+7,          0x0p+0, 0)
T(RD,    0x1.b3c4p+14,       0x1.4ep+7,          0x0p+0, 0)
T(RD,    0x1.d3a4p+14,       0x1.5ap+7,          0x0p+0, 0)
T(RD,    0x1.f4a4p+14,       0x1.66p+7,          0x0p+0, 0)
T(RD,    0x1.ffe4p+14,       0x1.6ap+7,          0x0p+0, 0)
T(RD,       0x1.2p+21,       0x1.8p+10,          0x0p+0, 0)
T(RD,        0x1p+124,         0x1p+62,          0x0p+0, 0)
T(RD,        0x1p+126,         0x1p+63,          0x0p+0, 0)
T(RD, 0x1.fffffcp-127,  0x1.fffffcp-64,  -0x1.fffffep-1, INEXACT)
T(RD, 0x1.000004p-126,         0x1p-63,  -0x1.fffffep-1, INEXACT)
T(RD,   0x1.ffffeep-1,   0x1.fffff6p-1,  -0x1.ffffd8p-2, INEXACT)
T(RD,    0x1.fffffp-1,   0x1.fffff6p-1,   -0x1.fffffp-1, INEXACT)
T(RD,   0x1.fffff2p-1,   0x1.fffff8p-1,  -0x1.ffffe8p-2, INEXACT)
T(RD,   0x1.fffff4p-1,   0x1.fffff8p-1,  -0x1.fffff6p-1, INEXACT)
T(RD,   0x1.fffff6p-1,   0x1.fffffap-1,  -0x1.fffff4p-2, INEXACT)
T(RD,   0x1.fffff8p-1,   0x1.fffffap-1,  -0x1.fffffcp-1, INEXACT)
T(RD,   0x1.fffffap-1,   0x1.fffffcp-1,  -0x1.fffffcp-2, INEXACT)
T(RD,   0x1.fffffcp-1,   0x1.fffffcp-1,  -0x1.fffffep-1, INEXACT)
T(RD,   0x1.000004p+0,          0x1p+0,  -0x1.fffffep-1, INEXACT)
T(RD,   0x1.000006p+0,   0x1.000002p+0,  -0x1.fffff8p-2, INEXACT)
T(RD,   0x1.000008p+0,   0x1.000002p+0,  -0x1.fffff8p-1, INEXACT)
T(RD,   0x1.00000ap+0,   0x1.000004p+0,  -0x1.ffffe8p-2, INEXACT)
T(RD,   0x1.00000cp+0,   0x1.000004p+0,  -0x1.ffffeep-1, INEXACT)
T(RD,   0x1.00000ep+0,   0x1.000006p+0,   -0x1.ffffdp-2, INEXACT)
T(RD, 0x1.fffffcp+125,  0x1.fffffcp+62,  -0x1.fffffep-1, INEXACT)
T(RD, 0x1.000004p+126,         0x1p+63,  -0x1.fffffep-1, INEXACT)
ARM_EXPECT_FAIL("RYNDA-246", RD,             nan,             nan,          0x0p+0, 0)
T(RD,       -0x1p-148,             nan,          0x0p+0, INVALID)
T(RD,     -0x1.4p-147,             nan,          0x0p+0, INVALID)
T(RD,     -0x1.cp-147,             nan,          0x0p+0, INVALID)
T(RD,     -0x1.2p-146,             nan,          0x0p+0, INVALID)
T(RD,-0x1.ffffdcp-127,             nan,          0x0p+0, INVALID)
T(RD,-0x1.ffffe4p-127,             nan,          0x0p+0, INVALID)
T(RD, -0x1.fffffp-127,             nan,          0x0p+0, INVALID)
T(RD,-0x1.fffff4p-127,             nan,          0x0p+0, INVALID)
T(RD,-0x1.fffff8p-127,             nan,          0x0p+0, INVALID)
T(RD,-0x1.fffffcp-127,             nan,          0x0p+0, INVALID)
T(RD,-0x1.fffffap-126,             nan,          0x0p+0, INVALID)
T(RD,       -0x1p-125,             nan,          0x0p+0, INVALID)
T(RD,-0x1.000002p-125,             nan,          0x0p+0, INVALID)
T(RD,        -0x1p-23,             nan,          0x0p+0, INVALID)
T(RD,        -0x1p-22,             nan,          0x0p+0, INVALID)
T(RD,      -0x1.8p-22,             nan,          0x0p+0, INVALID)
T(RD,  -0x1.000004p+1,             nan,          0x0p+0, INVALID)
T(RD,  -0x1.800008p+1,             nan,          0x0p+0, INVALID)
T(RD,  -0x1.fffff6p+1,             nan,          0x0p+0, INVALID)
T(RD,-0x1.fffff8p+125,             nan,          0x0p+0, INVALID)
T(RD,-0x1.000004p+126,             nan,          0x0p+0, INVALID)
T(RD,-0x1.fffffep+126,             nan,          0x0p+0, INVALID)
T(RD,-0x1.000004p+127,             nan,          0x0p+0, INVALID)
T(RN,        0x1p-148,         0x1p-74,          0x0p+0, 0)
T(RN,        0x1p-146,         0x1p-73,          0x0p+0, 0)
T(RN,        0x1p-128,         0x1p-64,          0x0p+0, 0)
T(RN,        0x1p-124,         0x1p-62,          0x0p+0, 0)
T(RN,       0x1.2p-15,        0x1.8p-8,          0x0p+0, 0)
T(RN,          0x1p-8,          0x1p-4,          0x0p+0, 0)
T(RN,        0x1.2p-5,        0x1.8p-3,          0x0p+0, 0)
T(RN,          0x1p-4,          0x1p-2,          0x0p+0, 0)
T(RN,        0x1.2p+3,        0x1.8p+1,          0x0p+0, 0)
T(RN,          0x1p+8,          0x1p+4,          0x0p+0, 0)
T(RN,       0x1.2p+11,        0x1.8p+5,          0x0p+0, 0)
T(RN,    0x1.9f24p+14,       0x1.46p+7,          0x0p+0, 0)
T(RN,    0x1.b3c4p+14,       0x1.4ep+7,          0x0p+0, 0)
T(RN,    0x1.d3a4p+14,       0x1.5ap+7,          0x0p+0, 0)
T(RN,    0x1.f4a4p+14,       0x1.66p+7,          0x0p+0, 0)
T(RN,    0x1.ffe4p+14,       0x1.6ap+7,          0x0p+0, 0)
T(RN,       0x1.2p+21,       0x1.8p+10,          0x0p+0, 0)
T(RN,        0x1p+124,         0x1p+62,          0x0p+0, 0)
T(RN,        0x1p+126,         0x1p+63,          0x0p+0, 0)
T(RN, 0x1.fffffcp-127,  0x1.fffffep-64,  0x1.000002p-25, INEXACT)
T(RN, 0x1.000004p-126,  0x1.000002p-63,  0x1.fffffcp-25, INEXACT)
T(RN,   0x1.ffffeep-1,   0x1.fffff6p-1,  -0x1.ffffd8p-2, INEXACT)
T(RN,    0x1.fffffp-1,   0x1.fffff8p-1,  0x1.000004p-21, INEXACT)
T(RN,   0x1.fffff2p-1,   0x1.fffff8p-1,  -0x1.ffffe8p-2, INEXACT)
T(RN,   0x1.fffff4p-1,   0x1.fffffap-1,  0x1.200004p-22, INEXACT)
T(RN,   0x1.fffff6p-1,   0x1.fffffap-1,  -0x1.fffff4p-2, INEXACT)
T(RN,   0x1.fffff8p-1,   0x1.fffffcp-1,  0x1.000002p-23, INEXACT)
T(RN,   0x1.fffffap-1,   0x1.fffffcp-1,  -0x1.fffffcp-2, INEXACT)
T(RN,   0x1.fffffcp-1,   0x1.fffffep-1,  0x1.000002p-25, INEXACT)
T(RN,   0x1.000004p+0,   0x1.000002p+0,  0x1.fffffcp-25, INEXACT)
T(RN,   0x1.000006p+0,   0x1.000002p+0,  -0x1.fffff8p-2, INEXACT)
T(RN,   0x1.000008p+0,   0x1.000004p+0,  0x1.fffff8p-23, INEXACT)
T(RN,   0x1.00000ap+0,   0x1.000004p+0,  -0x1.ffffe8p-2, INEXACT)
T(RN,   0x1.00000cp+0,   0x1.000006p+0,  0x1.1ffffap-21, INEXACT)
T(RN,   0x1.00000ep+0,   0x1.000006p+0,   -0x1.ffffdp-2, INEXACT)
T(RN, 0x1.fffffcp+125,  0x1.fffffep+62,  0x1.000002p-25, INEXACT)
T(RN, 0x1.000004p+126,  0x1.000002p+63,  0x1.fffffcp-25, INEXACT)
ARM_EXPECT_FAIL("RYNDA-246", RN,             nan,             nan,          0x0p+0, 0)
T(RN,       -0x1p-148,             nan,          0x0p+0, INVALID)
T(RN,     -0x1.4p-147,             nan,          0x0p+0, INVALID)
T(RN,     -0x1.cp-147,             nan,          0x0p+0, INVALID)
T(RN,     -0x1.2p-146,             nan,          0x0p+0, INVALID)
T(RN,-0x1.ffffdcp-127,             nan,          0x0p+0, INVALID)
T(RN,-0x1.ffffe4p-127,             nan,          0x0p+0, INVALID)
T(RN, -0x1.fffffp-127,             nan,          0x0p+0, INVALID)
T(RN,-0x1.fffff4p-127,             nan,          0x0p+0, INVALID)
T(RN,-0x1.fffff8p-127,             nan,          0x0p+0, INVALID)
T(RN,-0x1.fffffcp-127,             nan,          0x0p+0, INVALID)
T(RN,-0x1.fffffap-126,             nan,          0x0p+0, INVALID)
T(RN,       -0x1p-125,             nan,          0x0p+0, INVALID)
T(RN,-0x1.000002p-125,             nan,          0x0p+0, INVALID)
T(RN,        -0x1p-23,             nan,          0x0p+0, INVALID)
T(RN,        -0x1p-22,             nan,          0x0p+0, INVALID)
T(RN,      -0x1.8p-22,             nan,          0x0p+0, INVALID)
T(RN,  -0x1.000004p+1,             nan,          0x0p+0, INVALID)
T(RN,  -0x1.800008p+1,             nan,          0x0p+0, INVALID)
T(RN,  -0x1.fffff6p+1,             nan,          0x0p+0, INVALID)
T(RN,-0x1.fffff8p+125,             nan,          0x0p+0, INVALID)
T(RN,-0x1.000004p+126,             nan,          0x0p+0, INVALID)
T(RN,-0x1.fffffep+126,             nan,          0x0p+0, INVALID)
T(RN,-0x1.000004p+127,             nan,          0x0p+0, INVALID)
T(RU,        0x1p-148,         0x1p-74,          0x0p+0, 0)
T(RU,        0x1p-146,         0x1p-73,          0x0p+0, 0)
T(RU,        0x1p-128,         0x1p-64,          0x0p+0, 0)
T(RU,        0x1p-124,         0x1p-62,          0x0p+0, 0)
T(RU,       0x1.2p-15,        0x1.8p-8,          0x0p+0, 0)
T(RU,          0x1p-8,          0x1p-4,          0x0p+0, 0)
T(RU,        0x1.2p-5,        0x1.8p-3,          0x0p+0, 0)
T(RU,          0x1p-4,          0x1p-2,          0x0p+0, 0)
T(RU,        0x1.2p+3,        0x1.8p+1,          0x0p+0, 0)
T(RU,          0x1p+8,          0x1p+4,          0x0p+0, 0)
T(RU,       0x1.2p+11,        0x1.8p+5,          0x0p+0, 0)
T(RU,    0x1.9f24p+14,       0x1.46p+7,          0x0p+0, 0)
T(RU,    0x1.b3c4p+14,       0x1.4ep+7,          0x0p+0, 0)
T(RU,    0x1.d3a4p+14,       0x1.5ap+7,          0x0p+0, 0)
T(RU,    0x1.f4a4p+14,       0x1.66p+7,          0x0p+0, 0)
T(RU,    0x1.ffe4p+14,       0x1.6ap+7,          0x0p+0, 0)
T(RU,       0x1.2p+21,       0x1.8p+10,          0x0p+0, 0)
T(RU,        0x1p+124,         0x1p+62,          0x0p+0, 0)
T(RU,        0x1p+126,         0x1p+63,          0x0p+0, 0)
T(RU, 0x1.fffffcp-127,  0x1.fffffep-64,  0x1.000002p-25, INEXACT)
T(RU, 0x1.000004p-126,  0x1.000002p-63,  0x1.fffffcp-25, INEXACT)
T(RU,   0x1.ffffeep-1,   0x1.fffff8p-1,   0x1.000014p-1, INEXACT)
T(RU,    0x1.fffffp-1,   0x1.fffff8p-1,  0x1.000004p-21, INEXACT)
T(RU,   0x1.fffff2p-1,   0x1.fffffap-1,   0x1.00000cp-1, INEXACT)
T(RU,   0x1.fffff4p-1,   0x1.fffffap-1,  0x1.200004p-22, INEXACT)
T(RU,   0x1.fffff6p-1,   0x1.fffffcp-1,   0x1.000006p-1, INEXACT)
T(RU,   0x1.fffff8p-1,   0x1.fffffcp-1,  0x1.000002p-23, INEXACT)
T(RU,   0x1.fffffap-1,   0x1.fffffep-1,   0x1.000002p-1, INEXACT)
T(RU,   0x1.fffffcp-1,   0x1.fffffep-1,  0x1.000002p-25, INEXACT)
T(RU,   0x1.000004p+0,   0x1.000002p+0,  0x1.fffffcp-25, INEXACT)
T(RU,   0x1.000006p+0,   0x1.000004p+0,   0x1.000004p-1, INEXACT)
T(RU,   0x1.000008p+0,   0x1.000004p+0,  0x1.fffff8p-23, INEXACT)
T(RU,   0x1.00000ap+0,   0x1.000006p+0,   0x1.00000cp-1, INEXACT)
T(RU,   0x1.00000cp+0,   0x1.000006p+0,  0x1.1ffffap-21, INEXACT)
T(RU,   0x1.00000ep+0,   0x1.000008p+0,   0x1.000018p-1, INEXACT)
T(RU, 0x1.fffffcp+125,  0x1.fffffep+62,  0x1.000002p-25, INEXACT)
T(RU, 0x1.000004p+126,  0x1.000002p+63,  0x1.fffffcp-25, INEXACT)
ARM_EXPECT_FAIL("RYNDA-246", RU,             nan,             nan,          0x0p+0, 0)
T(RU,       -0x1p-148,             nan,          0x0p+0, INVALID)
T(RU,     -0x1.4p-147,             nan,          0x0p+0, INVALID)
T(RU,     -0x1.cp-147,             nan,          0x0p+0, INVALID)
T(RU,     -0x1.2p-146,             nan,          0x0p+0, INVALID)
T(RU,-0x1.ffffdcp-127,             nan,          0x0p+0, INVALID)
T(RU,-0x1.ffffe4p-127,             nan,          0x0p+0, INVALID)
T(RU, -0x1.fffffp-127,             nan,          0x0p+0, INVALID)
T(RU,-0x1.fffff4p-127,             nan,          0x0p+0, INVALID)
T(RU,-0x1.fffff8p-127,             nan,          0x0p+0, INVALID)
T(RU,-0x1.fffffcp-127,             nan,          0x0p+0, INVALID)
T(RU,-0x1.fffffap-126,             nan,          0x0p+0, INVALID)
T(RU,       -0x1p-125,             nan,          0x0p+0, INVALID)
T(RU,-0x1.000002p-125,             nan,          0x0p+0, INVALID)
T(RU,        -0x1p-23,             nan,          0x0p+0, INVALID)
T(RU,        -0x1p-22,             nan,          0x0p+0, INVALID)
T(RU,      -0x1.8p-22,             nan,          0x0p+0, INVALID)
T(RU,  -0x1.000004p+1,             nan,          0x0p+0, INVALID)
T(RU,  -0x1.800008p+1,             nan,          0x0p+0, INVALID)
T(RU,  -0x1.fffff6p+1,             nan,          0x0p+0, INVALID)
T(RU,-0x1.fffff8p+125,             nan,          0x0p+0, INVALID)
T(RU,-0x1.000004p+126,             nan,          0x0p+0, INVALID)
T(RU,-0x1.fffffep+126,             nan,          0x0p+0, INVALID)
T(RU,-0x1.000004p+127,             nan,          0x0p+0, INVALID)
T(RZ,        0x1p-148,         0x1p-74,          0x0p+0, 0)
T(RZ,        0x1p-146,         0x1p-73,          0x0p+0, 0)
T(RZ,        0x1p-128,         0x1p-64,          0x0p+0, 0)
T(RZ,        0x1p-124,         0x1p-62,          0x0p+0, 0)
T(RZ,       0x1.2p-15,        0x1.8p-8,          0x0p+0, 0)
T(RZ,          0x1p-8,          0x1p-4,          0x0p+0, 0)
T(RZ,        0x1.2p-5,        0x1.8p-3,          0x0p+0, 0)
T(RZ,          0x1p-4,          0x1p-2,          0x0p+0, 0)
T(RZ,        0x1.2p+3,        0x1.8p+1,          0x0p+0, 0)
T(RZ,          0x1p+8,          0x1p+4,          0x0p+0, 0)
T(RZ,       0x1.2p+11,        0x1.8p+5,          0x0p+0, 0)
T(RZ,    0x1.9f24p+14,       0x1.46p+7,          0x0p+0, 0)
T(RZ,    0x1.b3c4p+14,       0x1.4ep+7,          0x0p+0, 0)
T(RZ,    0x1.d3a4p+14,       0x1.5ap+7,          0x0p+0, 0)
T(RZ,    0x1.f4a4p+14,       0x1.66p+7,          0x0p+0, 0)
T(RZ,    0x1.ffe4p+14,       0x1.6ap+7,          0x0p+0, 0)
T(RZ,       0x1.2p+21,       0x1.8p+10,          0x0p+0, 0)
T(RZ,        0x1p+124,         0x1p+62,          0x0p+0, 0)
T(RZ,        0x1p+126,         0x1p+63,          0x0p+0, 0)
T(RZ, 0x1.fffffcp-127,  0x1.fffffcp-64,  -0x1.fffffep-1, INEXACT)
T(RZ, 0x1.000004p-126,         0x1p-63,  -0x1.fffffep-1, INEXACT)
T(RZ,   0x1.ffffeep-1,   0x1.fffff6p-1,  -0x1.ffffd8p-2, INEXACT)
T(RZ,    0x1.fffffp-1,   0x1.fffff6p-1,   -0x1.fffffp-1, INEXACT)
T(RZ,   0x1.fffff2p-1,   0x1.fffff8p-1,  -0x1.ffffe8p-2, INEXACT)
T(RZ,   0x1.fffff4p-1,   0x1.fffff8p-1,  -0x1.fffff6p-1, INEXACT)
T(RZ,   0x1.fffff6p-1,   0x1.fffffap-1,  -0x1.fffff4p-2, INEXACT)
T(RZ,   0x1.fffff8p-1,   0x1.fffffap-1,  -0x1.fffffcp-1, INEXACT)
T(RZ,   0x1.fffffap-1,   0x1.fffffcp-1,  -0x1.fffffcp-2, INEXACT)
T(RZ,   0x1.fffffcp-1,   0x1.fffffcp-1,  -0x1.fffffep-1, INEXACT)
T(RZ,   0x1.000004p+0,          0x1p+0,  -0x1.fffffep-1, INEXACT)
T(RZ,   0x1.000006p+0,   0x1.000002p+0,  -0x1.fffff8p-2, INEXACT)
T(RZ,   0x1.000008p+0,   0x1.000002p+0,  -0x1.fffff8p-1, INEXACT)
T(RZ,   0x1.00000ap+0,   0x1.000004p+0,  -0x1.ffffe8p-2, INEXACT)
T(RZ,   0x1.00000cp+0,   0x1.000004p+0,  -0x1.ffffeep-1, INEXACT)
T(RZ,   0x1.00000ep+0,   0x1.000006p+0,   -0x1.ffffdp-2, INEXACT)
T(RZ, 0x1.fffffcp+125,  0x1.fffffcp+62,  -0x1.fffffep-1, INEXACT)
T(RZ, 0x1.000004p+126,         0x1p+63,  -0x1.fffffep-1, INEXACT)
ARM_EXPECT_FAIL("RYNDA-246", RZ,             nan,             nan,          0x0p+0, 0)
T(RZ,       -0x1p-148,             nan,          0x0p+0, INVALID)
T(RZ,     -0x1.4p-147,             nan,          0x0p+0, INVALID)
T(RZ,     -0x1.cp-147,             nan,          0x0p+0, INVALID)
T(RZ,     -0x1.2p-146,             nan,          0x0p+0, INVALID)
T(RZ,-0x1.ffffdcp-127,             nan,          0x0p+0, INVALID)
T(RZ,-0x1.ffffe4p-127,             nan,          0x0p+0, INVALID)
T(RZ, -0x1.fffffp-127,             nan,          0x0p+0, INVALID)
T(RZ,-0x1.fffff4p-127,             nan,          0x0p+0, INVALID)
T(RZ,-0x1.fffff8p-127,             nan,          0x0p+0, INVALID)
T(RZ,-0x1.fffffcp-127,             nan,          0x0p+0, INVALID)
T(RZ,-0x1.fffffap-126,             nan,          0x0p+0, INVALID)
T(RZ,       -0x1p-125,             nan,          0x0p+0, INVALID)
T(RZ,-0x1.000002p-125,             nan,          0x0p+0, INVALID)
T(RZ,        -0x1p-23,             nan,          0x0p+0, INVALID)
T(RZ,        -0x1p-22,             nan,          0x0p+0, INVALID)
T(RZ,      -0x1.8p-22,             nan,          0x0p+0, INVALID)
T(RZ,  -0x1.000004p+1,             nan,          0x0p+0, INVALID)
T(RZ,  -0x1.800008p+1,             nan,          0x0p+0, INVALID)
T(RZ,  -0x1.fffff6p+1,             nan,          0x0p+0, INVALID)
T(RZ,-0x1.fffff8p+125,             nan,          0x0p+0, INVALID)
T(RZ,-0x1.000004p+126,             nan,          0x0p+0, INVALID)
T(RZ,-0x1.fffffep+126,             nan,          0x0p+0, INVALID)
T(RZ,-0x1.000004p+127,             nan,          0x0p+0, INVALID)
