﻿#include "ntd-test-libc.h"
#include <stdint.h>
#include <stdio.h>
#include "mtest.h"

static struct f_f t[] = {
#include "ucb/tanf.h"
#include "sanity/tanf.h"
#include "special/tanf.h"

};

int testtanf(void)
{
    #pragma STDC FENV_ACCESS ON
    float y;
    float d;
    int e, i, err = 0;
    struct f_f *p;

    for (i = 0; i < sizeof t/sizeof *t; i++) {
        p = t + i;

        if (p->r < 0)
            continue;
        fesetround(p->r);
        feclearexcept(FE_ALL_EXCEPT);
        y = tanf(p->x);
        e = fetestexcept(INEXACT|INVALID|DIVBYZERO|UNDERFLOW|OVERFLOW);

        int passed = t_checkexcept(e, p->e, p->r);
        char *msg = NULL;
        asprintf(&msg, "bad fp exception: %s tanf(%a)=%a, %s",
                rstr(p->r), p->x, p->y, ESTRS(e, p));
        if (p->expect_failure) {
            NTD_TESTCASE_KNOWN_FAILURE(p->fail_msg, passed, p->file, p->line, msg);
        } else {
            if (!passed) err++;
            NTD_TESTCASE(passed, p->file, p->line, msg);
        }
        free(msg);
        d = ulperrf(y, p->y, p->dy);
        if (!checkulp(d, p->r)) {
            printf("%s:%d: %s tanf(%a) want %a got %a ulperr %.3f = %a + %a\n",
                short_path(p->file), p->line, rstr(p->r), p->x, p->y, y, d, d-p->dy, p->dy);
            err++;
        }
    }
    return !!err;
}
