﻿/*---------------------------------------------------------------------------*
  Copyright (C)2016 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#define _XOPEN_SOURCE 700
#include <stdlib.h>

int testrandom_after_init();

static char state[128];
/* Initialize the random seed to what the random() tests expect in case any
   other part of the testsuite called random() prior to this test */
int testrandom()
{
  void * orig = initstate(1, state, sizeof state);
  int result = testrandom_after_init();
  setstate(orig);
  return result;
}

#define main testrandom_after_init
#include "../orig-musl-libc-test/src/functional/random.c"
#undef main
