﻿/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include "musl-libc-tests/musl-libc-tests.h"

extern void musl_libc_test__functional__run(void);
extern void musl_libc_test__math__run(void);
extern void musl_libc_test__musl__run(void);
extern void musl_libc_test__new_tests__run(void);
extern void musl_libc_test__regression__run(void);


/* The main function for musl-libc-test tests */
void musl_libc_tests(void)
{
    NTD_TEST_GROUP_START("MUSL LIBC TESTS", 0);

    NTD_TEST_GROUP_START("functional", 1);
    musl_libc_test__functional__run();
    NTD_TEST_GROUP_END("functional", 1);

    NTD_TEST_GROUP_START("math", 1);
    musl_libc_test__math__run();
    NTD_TEST_GROUP_END("math", 1);

    NTD_TEST_GROUP_START("musl", 1);
    musl_libc_test__musl__run();
    NTD_TEST_GROUP_END("musl", 1);

    NTD_TEST_GROUP_START("regression", 1);
    musl_libc_test__regression__run();
    NTD_TEST_GROUP_END("regression", 1);

    //<other calls to tests will be placed here>...

    NTD_TEST_GROUP_START("MUSL LIBC TESTS", 0);
}
